/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.eureka.client.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.eureka.EurekaConfiguration;
import io.micronaut.discovery.eureka.EurekaServiceInstance;
import io.micronaut.discovery.eureka.client.v2.ApplicationInfo;
import io.micronaut.discovery.eureka.client.v2.EurekaClient;
import io.micronaut.discovery.eureka.client.v2.InstanceInfo;
import io.micronaut.discovery.eureka.condition.RequiresEureka;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.jackson.annotation.JacksonFeatures;
import io.micronaut.validation.Validated;
import io.reactivex.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;

@Client(id="eureka", path="/eureka", configuration=EurekaConfiguration.class)
@JacksonFeatures(enabledSerializationFeatures={SerializationFeature.WRAP_ROOT_VALUE}, disabledSerializationFeatures={SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED}, enabledDeserializationFeatures={DeserializationFeature.UNWRAP_ROOT_VALUE, DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
@Validated
@RequiresEureka
abstract class AbstractEurekaClient
implements EurekaClient {
    static final String EXPR_EUREKA_REGISTRATION_RETRY_DELAY = "${eureka.client.registration.retry-delay:3s}";
    static final String EXPR_EUREKA_REGISTRATION_RETRY_COUNT = "${eureka.client.registration.retry-count:10}";
    private final EurekaConfiguration.EurekaDiscoveryConfiguration discoveryConfiguration;

    protected AbstractEurekaClient(EurekaConfiguration.EurekaDiscoveryConfiguration discoveryConfiguration) {
        this.discoveryConfiguration = discoveryConfiguration;
    }

    public String getDescription() {
        return "eureka";
    }

    public Publisher<List<ServiceInstance>> getInstances(String serviceId) {
        serviceId = NameUtils.hyphenate((String)serviceId);
        Flowable flowable = Flowable.fromPublisher(this.getApplicationInfo(serviceId)).map(applicationInfo -> {
            List<InstanceInfo> instances = applicationInfo.getInstances();
            return instances.stream().map(ii -> {
                if (!this.discoveryConfiguration.isUseSecurePort()) {
                    ii.setSecurePort(-1);
                }
                return new EurekaServiceInstance((InstanceInfo)ii);
            }).collect(Collectors.toList());
        });
        return flowable.onErrorReturn(throwable -> {
            HttpClientResponseException hcre;
            if (throwable instanceof HttpClientResponseException && (hcre = (HttpClientResponseException)throwable).getStatus() == HttpStatus.NOT_FOUND) {
                return Collections.emptyList();
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new HttpClientException("Internal Client Error: " + throwable.getMessage(), throwable);
        });
    }

    @Override
    public Publisher<List<ApplicationInfo>> getApplicationInfos() {
        return Publishers.map(this.getApplicationInfosInternal(), applicationInfos -> ((ApplicationInfos)applicationInfos).applications);
    }

    @Override
    public Publisher<List<ApplicationInfo>> getApplicationVips(String vipAddress) {
        return Publishers.map(this.getApplicationVipsInternal(vipAddress), applicationInfos -> ((ApplicationInfos)applicationInfos).applications);
    }

    public Publisher<List<String>> getServiceIds() {
        return Publishers.map(this.getApplicationInfosInternal(), applicationInfos -> ((ApplicationInfos)applicationInfos).applications.stream().map(ApplicationInfo::getName).collect(Collectors.toList()));
    }

    @Get(value="/apps")
    @Produces(single=true)
    public abstract Publisher<ApplicationInfos> getApplicationInfosInternal();

    @Get(value="/vips/{vipAddress}")
    @Produces(single=true)
    public abstract Publisher<ApplicationInfos> getApplicationVipsInternal(String var1);

    @JsonRootName(value="applications")
    static class ApplicationInfos {
        private List<ApplicationInfo> applications;

        @JsonCreator
        public ApplicationInfos(@JsonProperty(value="application") List<ApplicationInfo> applications) {
            this.applications = applications != null ? applications : Collections.emptyList();
        }

        @JsonProperty(value="application")
        public List<ApplicationInfo> getApplications() {
            return this.applications;
        }
    }
}

