/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.eureka.health;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.discovery.eureka.client.v2.EurekaClient;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import io.reactivex.Flowable;
import java.util.Collections;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@Requirements(value={@Requires(classes={HealthIndicator.class}), @Requires(beans={EurekaClient.class})})
public class EurekaHealthIndicator
implements HealthIndicator {
    private final EurekaClient eurekaClient;

    public EurekaHealthIndicator(EurekaClient eurekaClient) {
        this.eurekaClient = eurekaClient;
    }

    public Flowable<HealthResult> getResult() {
        Flowable serviceIds = Flowable.fromPublisher((Publisher)this.eurekaClient.getServiceIds());
        return serviceIds.map(ids -> {
            HealthResult.Builder builder = HealthResult.builder((String)"eureka", (HealthStatus)HealthStatus.UP);
            return builder.details(Collections.singletonMap("available-services", ids)).build();
        }).onErrorReturn(throwable -> {
            HealthResult.Builder builder = HealthResult.builder((String)"eureka", (HealthStatus)HealthStatus.DOWN);
            builder.exception(throwable);
            return builder.build();
        });
    }
}

