/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.kubernetes;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.DiscoveryClient;
import io.micronaut.discovery.ServiceInstance;
import io.reactivex.Flowable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(env={"k8s"})
public class KubernetesDiscoveryClient
implements DiscoveryClient {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesDiscoveryClient.class);
    private static final String SERVICE_SUFFIX = "_SERVICE";
    private static final String HOST_SUFFIX = "_SERVICE_HOST";
    private static final String PUBLISHED_SUFFIX = "_PUBLISHED";
    private static final String RANDOM_PORTS_SUFFIX = "_RANDOM_PORTS";
    private static final String[] SUFFIXES = new String[]{"_PUBLISHED_SERVICE_HOST", "_RANDOM_PORTS_SERVICE_HOST", "_SERVICE_HOST"};
    private static final String PORT_SUFFIX = "_SERVICE_PORT";
    private static final String HTTPS_PORT_SUFFIX = "_SERVICE_PORT_HTTPS";
    private final Map<String, ServiceInstance> serviceIds;

    public KubernetesDiscoveryClient() {
        Map serviceInstanceMap = this.resolveEnvironment().entrySet().stream().filter(this::keyEndsWithSuffix).map(this::entryToServiceInstance).filter(Objects::nonNull).collect(Collectors.toMap(ServiceInstance::getId, Function.identity(), (x, y) -> x));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Discovered Services from Kubernetes environment:");
            for (ServiceInstance serviceInstance : serviceInstanceMap.values()) {
                LOG.debug("* {} - {}", (Object)serviceInstance.getId(), (Object)serviceInstance.getURI());
            }
        }
        this.serviceIds = serviceInstanceMap;
    }

    private boolean keyEndsWithSuffix(Map.Entry<String, String> entry) {
        String key = entry.getKey();
        for (String suffix : SUFFIXES) {
            if (!key.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private ServiceInstance entryToServiceInstance(Map.Entry<String, String> entry) {
        Map<String, String> env = this.resolveEnvironment();
        ServiceInstance si = null;
        String key = entry.getKey();
        String serviceId = key.substring(0, key.length() - HOST_SUFFIX.length());
        String host = entry.getValue();
        boolean isSecure = false;
        String port = env.get(serviceId + HTTPS_PORT_SUFFIX);
        if (StringUtils.isEmpty((CharSequence)port)) {
            port = env.get(serviceId + PORT_SUFFIX);
        } else {
            isSecure = true;
        }
        if (port != null) {
            if (serviceId.endsWith(PUBLISHED_SUFFIX)) {
                serviceId = serviceId.substring(0, serviceId.length() - PUBLISHED_SUFFIX.length());
            } else if (serviceId.endsWith(RANDOM_PORTS_SUFFIX)) {
                serviceId = serviceId.substring(0, serviceId.length() - RANDOM_PORTS_SUFFIX.length());
            }
            serviceId = serviceId.toLowerCase(Locale.ENGLISH).replace('_', '-');
            si = ServiceInstance.builder((String)serviceId, (URI)URI.create((isSecure ? "https://" : "http://") + host + ":" + port)).build();
        }
        return si;
    }

    public Flowable<List<ServiceInstance>> getInstances(String serviceId) {
        ServiceInstance serviceInstance = this.serviceIds.get(serviceId);
        if (serviceInstance != null) {
            return Flowable.just(Collections.singletonList(serviceInstance));
        }
        return Flowable.just(Collections.emptyList());
    }

    public Flowable<List<String>> getServiceIds() {
        return Flowable.just(new ArrayList<String>(this.serviceIds.keySet()));
    }

    public String getDescription() {
        return "kubernetes";
    }

    public void close() throws IOException {
    }

    protected Map<String, String> resolveEnvironment() {
        return System.getenv();
    }
}

