/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.client.config;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.context.env.BootstrapPropertySourceLocator;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Blocking;
import io.micronaut.discovery.config.ConfigurationClient;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Singleton
@Requires(property="micronaut.config-client.enabled", value="true", defaultValue="false")
@BootstrapContextCompatible
public class DistributedPropertySourceLocator
implements BootstrapPropertySourceLocator {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedPropertySourceLocator.class);
    private final ConfigurationClient configurationClient;
    private final Duration readTimeout;

    public DistributedPropertySourceLocator(ConfigurationClient configurationClient, @Value(value="${micronaut.config-client.read-timeout:10s}") Duration readTimeout) {
        this.configurationClient = configurationClient;
        this.readTimeout = readTimeout;
    }

    @Blocking
    public Iterable<PropertySource> findPropertySources(Environment environment) throws ConfigurationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving configuration sources from client: {}", (Object)this.configurationClient);
        }
        try {
            Flux propertySourceFlowable = Flux.from((Publisher)this.configurationClient.getPropertySources(environment));
            List propertySources = (List)propertySourceFlowable.timeout(Duration.ofMillis(this.readTimeout.toMillis())).collectList().block();
            if (LOG.isInfoEnabled()) {
                LOG.info("Resolved {} configuration sources from client: {}", (Object)propertySources.size(), (Object)this.configurationClient);
            }
            return propertySources;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof TimeoutException) {
                throw new ConfigurationException("Read timeout occurred reading distributed configuration from client: " + this.configurationClient.getDescription(), (Throwable)e);
            }
            throw e;
        }
    }
}

