/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.client.registration;

import io.micronaut.discovery.EmbeddedServerInstance;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.registration.AutoRegistration;
import io.micronaut.discovery.registration.RegistrationConfiguration;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import java.time.Duration;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;

public abstract class DiscoveryServiceAutoRegistration
extends AutoRegistration {
    protected DiscoveryServiceAutoRegistration(RegistrationConfiguration registrationConfiguration) {
        super(registrationConfiguration);
    }

    protected void performRegistration(final String discoveryService, final RegistrationConfiguration registration, final ServiceInstance instance, Publisher<HttpStatus> registrationObservable) {
        Flux registrationFlowable = Flux.from(registrationObservable);
        Duration timeout = registration.getTimeout().orElse(null);
        if (timeout != null) {
            registrationFlowable = registrationFlowable.timeout(Duration.ofMillis(timeout.toMillis()));
        }
        registrationFlowable.subscribe((Subscriber)new Subscriber<HttpStatus>(){

            public void onSubscribe(Subscription s) {
                s.request(1L);
            }

            public void onNext(HttpStatus httpStatus) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Registered service [{}] with {}", (Object)instance.getId(), (Object)discoveryService);
                }
            }

            public void onError(Throwable t) {
                if (LOG.isErrorEnabled()) {
                    String message = DiscoveryServiceAutoRegistration.this.getErrorMessage(discoveryService, t);
                    LOG.error(message, t);
                }
                if (registration.isFailFast() && instance instanceof EmbeddedServerInstance) {
                    ((EmbeddedServerInstance)instance).getEmbeddedServer().stop();
                }
            }

            public void onComplete() {
                DiscoveryServiceAutoRegistration.this.registered.set(true);
            }
        });
    }

    protected String getErrorMessage(Throwable e, String description) {
        HttpClientResponseException hcre;
        String message = e instanceof HttpClientResponseException ? ((hcre = (HttpClientResponseException)e).getStatus() == HttpStatus.BAD_REQUEST ? description + hcre.getResponse().getBody(String.class).orElse(e.getMessage()) : description + e.getMessage()) : description + e.getMessage();
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performDeregistration(final String discoveryService, RegistrationConfiguration registration, Publisher<HttpStatus> deregisterPublisher, final String applicationName) {
        Flux deregisterFlowable = Flux.from(deregisterPublisher);
        Duration timeout = registration.getTimeout().orElse(null);
        if (timeout != null) {
            deregisterFlowable = deregisterFlowable.timeout(Duration.ofMillis(timeout.toMillis()));
        }
        if (registration.isFailFast()) {
            try {
                deregisterFlowable.blockFirst();
                if (!LOG.isInfoEnabled()) return;
                LOG.info("De-registered service [{}] with {}", (Object)applicationName, (Object)discoveryService);
                return;
            }
            catch (Throwable t) {
                if (!LOG.isErrorEnabled()) return;
                LOG.error("Error occurred de-registering service [" + applicationName + "] with " + discoveryService + ": " + t.getMessage(), t);
                return;
            }
            finally {
                this.registered.set(false);
            }
        } else {
            deregisterFlowable.subscribe((Subscriber)new Subscriber<HttpStatus>(){

                public void onSubscribe(Subscription subscription) {
                    subscription.request(1L);
                }

                public void onNext(HttpStatus httpStatus) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("De-registered service [{}] with {}", (Object)applicationName, (Object)discoveryService);
                    }
                }

                public void onError(Throwable t) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Error occurred de-registering service [" + applicationName + "] with " + discoveryService + ": " + t.getMessage(), t);
                    }
                    DiscoveryServiceAutoRegistration.this.registered.set(false);
                }

                public void onComplete() {
                    DiscoveryServiceAutoRegistration.this.registered.set(false);
                }
            });
        }
    }

    private String getErrorMessage(String discoveryService, Throwable e) {
        String description = "Error occurred during service registration with " + discoveryService + ": ";
        return this.getErrorMessage(e, description);
    }
}

