/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.spring.config.client;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.discovery.spring.config.SpringCloudClientConfiguration;
import io.micronaut.discovery.spring.config.client.ConfigServerResponse;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.retry.annotation.Retryable;
import org.reactivestreams.Publisher;

@Client(value="${spring.cloud.config.uri:`http://localhost:8888`}", configuration=SpringCloudClientConfiguration.class)
@BootstrapContextCompatible
@Requires(beans={SpringCloudClientConfiguration.class})
public interface SpringCloudConfigClient {
    public static final String CLIENT_DESCRIPTION = "spring-cloud-config-client";

    @Get(value="/{applicationName}{/profiles}")
    @Produces(single=true)
    @Retryable(attempts="${spring.cloud.config.config.retry-count:3}", delay="${spring.cloud.config.config.retry-delay:1s}")
    public Publisher<ConfigServerResponse> readValues(@NonNull String var1, @Nullable String var2);

    @Get(value="/{applicationName}{/profiles}{/label}")
    @Produces(single=true)
    @Retryable(attempts="${spring.cloud.config.config.retry-count:3}", delay="${spring.cloud.config.config.retry-delay:1s}")
    public Publisher<ConfigServerResponse> readValues(@NonNull String var1, @Nullable String var2, @Nullable String var3);
}

