/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.client.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.discovery.consul.client.v1.NewCheck;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(as=TTLCheck.class)
public class TTLCheck
extends NewCheck {
    private Duration ttl;

    @JsonProperty(value="TTL")
    public Optional<String> getTtl() {
        if (this.ttl != null) {
            return Optional.of(this.ttl.getSeconds() + "s");
        }
        return Optional.empty();
    }

    public Optional<Duration> ttl() {
        return Optional.ofNullable(this.ttl);
    }

    @JsonProperty(value="TTL")
    void setTtl(String ttl) {
        this.ttl = (Duration)ConversionService.SHARED.convert((Object)ttl, Duration.class).orElseThrow(() -> new IllegalArgumentException("Invalid TTL Returned"));
    }

    public NewCheck ttl(Duration interval) {
        if (interval != null) {
            this.ttl = interval;
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TTLCheck ttlCheck = (TTLCheck)o;
        return Objects.equals(this.ttl, ttlCheck.ttl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.ttl);
    }
}

