/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.client.v1;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.discovery.consul.client.v1.CatalogEntry;
import io.micronaut.discovery.consul.client.v1.HealthEntry;
import io.micronaut.discovery.consul.client.v1.KeyValue;
import io.micronaut.discovery.consul.client.v1.LocalAgentConfiguration;
import io.micronaut.discovery.consul.client.v1.MemberEntry;
import io.micronaut.discovery.consul.client.v1.NewServiceEntry;
import io.micronaut.discovery.consul.client.v1.ServiceEntry;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.retry.annotation.Retryable;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;

public interface ConsulOperations {
    @Put(value="/kv/{+key}", processes={"text/plain"}, single=true)
    public Publisher<Boolean> putValue(String var1, @Body String var2);

    @Get(uri="/kv/{+key}?recurse", single=true)
    public Publisher<List<KeyValue>> readValues(String var1);

    @Get(uri="/kv/{+key}?recurse=true{&dc}{&raw}{&seperator}", single=true)
    @Retryable(attempts="${consul.client.config.retry-count:3}", delay="${consul.client.config.retry-delay:1s}")
    public Publisher<List<KeyValue>> readValues(String var1, @Nullable @QueryValue(value="dc") String var2, @Nullable Boolean var3, @Nullable String var4);

    @Put(value="/agent/check/pass/{checkId}{?note}")
    @Retryable(attempts="${consul.client.registration.retry-count:3}", delay="${consul.client.registration.retry-delay:3s}")
    public Publisher<HttpStatus> pass(String var1, @Nullable String var2);

    @Put(value="/agent/check/warn/{checkId}{?note}")
    public Publisher<HttpStatus> warn(String var1, @Nullable String var2);

    @Put(value="/agent/check/fail/{checkId}{?note}")
    @Retryable(attempts="${consul.client.registration.retry-count:3}", delay="${consul.client.registration.retry-delay:3s}")
    public Publisher<HttpStatus> fail(String var1, @Nullable String var2);

    @Get(uri="/status/leader", single=true)
    @Retryable
    public Publisher<String> status();

    @Put(uri="/catalog/register", single=true)
    public Publisher<Boolean> register(@NotNull @Body CatalogEntry var1);

    @Put(uri="/catalog/deregister", single=true)
    public Publisher<Boolean> deregister(@NotNull @Body CatalogEntry var1);

    @Put(value="/agent/service/register")
    @Retryable(attempts="${consul.client.registration.retry-count:3}", delay="${consul.client.registration.retry-delay:3s}")
    public Publisher<HttpStatus> register(@NotNull @Body NewServiceEntry var1);

    @Put(value="/agent/service/deregister/{service}")
    @Retryable(attempts="${consul.client.registration.retry-count:3}", delay="${consul.client.registration.retry-delay:3s}")
    public Publisher<HttpStatus> deregister(@NotNull String var1);

    @Get(uri="/agent/services", single=true)
    public Publisher<Map<String, ServiceEntry>> getServices();

    @Get(uri="/agent/members", single=true)
    public Publisher<List<MemberEntry>> getMembers();

    @Get(uri="/agent/self", single=true)
    public Publisher<LocalAgentConfiguration> getSelf();

    @Get(uri="/health/service/{service}{?passing,tag,dc}", single=true)
    public Publisher<List<HealthEntry>> getHealthyServices(@NotNull String var1, @Nullable Boolean var2, @Nullable String var3, @Nullable String var4);

    @Get(uri="/catalog/nodes", single=true)
    public Publisher<List<CatalogEntry>> getNodes();

    @Get(uri="/catalog/nodes?dc={datacenter}", single=true)
    public Publisher<List<CatalogEntry>> getNodes(@NotNull String var1);

    @Get(uri="/catalog/services", single=true)
    public Publisher<Map<String, List<String>>> getServiceNames();

    default public Publisher<HttpStatus> pass(String checkId) {
        return this.pass(checkId, null);
    }

    default public Publisher<HttpStatus> warn(String checkId) {
        return this.warn(checkId, null);
    }

    default public Publisher<HttpStatus> fail(String checkId) {
        return this.fail(checkId, null);
    }

    default public Publisher<List<HealthEntry>> getHealthyServices(@NotNull String service) {
        return this.getHealthyServices(service, null, null, null);
    }
}

