/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.spring.config;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.config.ConfigurationClient;
import io.micronaut.discovery.spring.config.SpringCloudClientConfiguration;
import io.micronaut.discovery.spring.config.client.ConfigServerPropertySource;
import io.micronaut.discovery.spring.config.client.ConfigServerResponse;
import io.micronaut.discovery.spring.config.client.SpringCloudConfigClient;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

@Singleton
@BootstrapContextCompatible
@Requires(beans={SpringCloudClientConfiguration.class})
public class SpringCloudConfigurationClient
implements ConfigurationClient {
    private static final Logger LOG = LoggerFactory.getLogger(SpringCloudConfigurationClient.class);
    private final SpringCloudConfigClient springCloudConfigClient;
    private final SpringCloudClientConfiguration springCloudConfiguration;
    private final ApplicationConfiguration applicationConfiguration;
    private ExecutorService executionService;

    protected SpringCloudConfigurationClient(SpringCloudConfigClient springCloudConfigClient, SpringCloudClientConfiguration springCloudConfiguration, ApplicationConfiguration applicationConfiguration, @Named(value="io") @Nullable ExecutorService executionService) {
        this.springCloudConfigClient = springCloudConfigClient;
        this.springCloudConfiguration = springCloudConfiguration;
        this.applicationConfiguration = applicationConfiguration;
        this.executionService = executionService;
    }

    public Publisher<PropertySource> getPropertySources(Environment environment) {
        String authorization;
        if (!this.springCloudConfiguration.getConfiguration().isEnabled()) {
            return Flux.empty();
        }
        Optional configuredApplicationName = this.applicationConfiguration.getName();
        if (configuredApplicationName.isEmpty()) {
            return Flux.empty();
        }
        String applicationName = this.springCloudConfiguration.getName().orElse((String)configuredApplicationName.get());
        Set activeNames = environment.getActiveNames();
        String profiles = StringUtils.trimToNull((String)String.join((CharSequence)",", activeNames));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Spring Cloud Config Active: {}", this.springCloudConfiguration.getUri());
            LOG.debug("Application Name: {}, Application Profiles: {}, label: {}", new Object[]{applicationName, profiles, this.springCloudConfiguration.getLabel()});
        }
        Publisher<ConfigServerResponse> responsePublisher = (authorization = SpringCloudConfigurationClient.getAuthorization(this.springCloudConfiguration)) == null ? (this.springCloudConfiguration.getLabel() == null ? this.springCloudConfigClient.readValues(applicationName, profiles) : this.springCloudConfigClient.readValues(applicationName, profiles, this.springCloudConfiguration.getLabel())) : (this.springCloudConfiguration.getLabel() == null ? this.springCloudConfigClient.readValuesAuthorized(applicationName, profiles, authorization) : this.springCloudConfigClient.readValuesAuthorized(applicationName, profiles, this.springCloudConfiguration.getLabel(), authorization));
        Flux configurationValues = Flux.from(responsePublisher).onErrorResume(throwable -> {
            HttpClientResponseException httpClientResponseException;
            if (throwable instanceof HttpClientResponseException && (httpClientResponseException = (HttpClientResponseException)throwable).getStatus() == HttpStatus.NOT_FOUND) {
                if (this.springCloudConfiguration.isFailFast()) {
                    return Flux.error((Throwable)new ConfigurationException("Could not locate PropertySource and the fail fast property is set", throwable));
                }
                return Flux.empty();
            }
            return Flux.error((Throwable)new ConfigurationException("Error reading distributed configuration from Spring Cloud: " + throwable.getMessage(), throwable));
        }).flatMap(response -> {
            List<ConfigServerPropertySource> springSources = response.getPropertySources();
            if (CollectionUtils.isEmpty(springSources)) {
                return Flux.empty();
            }
            int baseOrder = -100;
            ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>(springSources.size());
            for (int i = springSources.size() - 1; i >= 0; --i) {
                ConfigServerPropertySource springSource = springSources.get(i);
                propertySources.add(PropertySource.of((String)springSource.getName(), springSource.getSource(), (int)(++baseOrder)));
            }
            return Flux.fromIterable(propertySources);
        });
        if (this.executionService != null) {
            return configurationValues.subscribeOn(Schedulers.fromExecutor((Executor)this.executionService));
        }
        return configurationValues;
    }

    @NonNull
    public final String getDescription() {
        return "spring-cloud-config-client";
    }

    private static String getAuthorization(SpringCloudClientConfiguration springCloudConfiguration) {
        String authorization = null;
        if (springCloudConfiguration.getUsername().isPresent() && springCloudConfiguration.getPassword().isPresent()) {
            String basicAuth = springCloudConfiguration.getUsername().get() + ":" + springCloudConfiguration.getPassword().get();
            authorization = "Basic " + Base64.getEncoder().encodeToString(basicAuth.getBytes());
        }
        return authorization;
    }
}

