/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.vault.config;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.discovery.config.ConfigDiscoveryConfiguration;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Inject;

@ConfigurationProperties(value="vault.client")
@BootstrapContextCompatible
@Requires(property="vault.client")
public class VaultClientConfiguration
extends HttpClientConfiguration {
    public static final String PREFIX = "vault.client";
    public static final String VAULT_CLIENT_CONFIG_ENDPOINT = "${vault.client.uri}";
    private static final String DEFAULT_URI = "http://locahost:8200";
    private static final Boolean DEFAULT_FAIL_FAST = false;
    private static final String DEFAULT_SECRET_ENGINE = "secret";
    private static final String DEFAULT_PATH_PREFIX = "";
    private static final VaultKvVersion DEFAULT_KV_VERSION = VaultKvVersion.V2;
    private final VaultClientConnectionPoolConfiguration vaultClientConnectionPoolConfiguration;
    private final VaultClientDiscoveryConfiguration vaultClientDiscoveryConfiguration = new VaultClientDiscoveryConfiguration();
    private String uri = "http://locahost:8200";
    private String token;
    private VaultKvVersion kvVersion = DEFAULT_KV_VERSION;
    private String secretEngineName = "secret";
    private String pathPrefix = "";
    private boolean failFast = DEFAULT_FAIL_FAST;

    @Inject
    public VaultClientConfiguration(VaultClientConnectionPoolConfiguration vaultClientConnectionPoolConfiguration, ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
        this.vaultClientConnectionPoolConfiguration = vaultClientConnectionPoolConfiguration;
    }

    public HttpClientConfiguration.ConnectionPoolConfiguration getConnectionPoolConfiguration() {
        return this.vaultClientConnectionPoolConfiguration;
    }

    public VaultClientDiscoveryConfiguration getDiscoveryConfiguration() {
        return this.vaultClientDiscoveryConfiguration;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public VaultKvVersion getKvVersion() {
        return this.kvVersion;
    }

    public void setKvVersion(VaultKvVersion kvVersion) {
        this.kvVersion = kvVersion;
    }

    public String getSecretEngineName() {
        return this.secretEngineName;
    }

    public void setSecretEngineName(String secretEngineName) {
        this.secretEngineName = secretEngineName;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    @ConfigurationProperties(value="config")
    @BootstrapContextCompatible
    @Requires(property="vault.client")
    public static class VaultClientDiscoveryConfiguration
    extends ConfigDiscoveryConfiguration {
        public static final String PREFIX = "vault.client.config";
    }

    public static enum VaultKvVersion {
        V1,
        V2;

    }

    @ConfigurationProperties(value="pool")
    @BootstrapContextCompatible
    @Requires(property="vault.client")
    public static class VaultClientConnectionPoolConfiguration
    extends HttpClientConfiguration.ConnectionPoolConfiguration {
    }
}

