/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.registration;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.EmbeddedServerInstance;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.ServiceInstanceIdGenerator;
import io.micronaut.discovery.client.registration.DiscoveryServiceAutoRegistration;
import io.micronaut.discovery.consul.ConsulConfiguration;
import io.micronaut.discovery.consul.client.v1.ConsulCheck;
import io.micronaut.discovery.consul.client.v1.ConsulCheckStatus;
import io.micronaut.discovery.consul.client.v1.ConsulClient;
import io.micronaut.discovery.consul.client.v1.ConsulNewServiceEntry;
import io.micronaut.discovery.exceptions.DiscoveryException;
import io.micronaut.discovery.registration.RegistrationException;
import io.micronaut.health.HealthStatus;
import io.micronaut.health.HeartbeatConfiguration;
import io.micronaut.http.HttpStatus;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import jakarta.inject.Singleton;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Singleton
@Requires(beans={ConsulClient.class, ConsulConfiguration.class})
public class ConsulAutoRegistration
extends DiscoveryServiceAutoRegistration {
    private static final String DEFAULT_CHECK_STATUS = ConsulCheckStatus.PASSING.toString();
    private final ConsulClient consulClient;
    private final HeartbeatConfiguration heartbeatConfiguration;
    private final ConsulConfiguration consulConfiguration;
    private final ServiceInstanceIdGenerator idGenerator;
    private final Environment environment;

    protected ConsulAutoRegistration(Environment environment, ConsulClient consulClient, HeartbeatConfiguration heartbeatConfiguration, ConsulConfiguration consulConfiguration, ServiceInstanceIdGenerator idGenerator) {
        super(consulConfiguration.getRegistration());
        this.environment = environment;
        this.consulClient = consulClient;
        this.heartbeatConfiguration = heartbeatConfiguration;
        this.consulConfiguration = consulConfiguration;
        this.idGenerator = idGenerator;
    }

    protected void pulsate(ServiceInstance instance, HealthStatus status) {
        ConsulConfiguration.ConsulRegistrationConfiguration registration = this.consulConfiguration.getRegistration();
        if (registration != null && !registration.getCheck().isHttp() && registration.getCheck().isEnabled() && this.registered.get()) {
            String checkId = "service:" + this.idGenerator.generateId(this.environment, instance);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reporting status for Check ID [{}]: {}", (Object)checkId, (Object)status);
            }
            if (status.equals((Object)HealthStatus.UP)) {
                Mono passPublisher = Mono.from(this.consulClient.pass(checkId));
                passPublisher.subscribe(httpStatus -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Successfully reported passing state to Consul");
                    }
                }, throwable -> {
                    Mono.from(this.consulClient.getServiceIds()).subscribe(serviceIds -> {
                        String serviceId = this.idGenerator.generateId(this.environment, instance);
                        if (!serviceIds.contains(serviceId)) {
                            if (LOG.isInfoEnabled()) {
                                LOG.info("Instance [{}] no longer registered with Consul. Attempting re-registration.", (Object)instance.getId());
                            }
                            this.register(instance);
                        }
                    });
                    if (LOG.isErrorEnabled()) {
                        LOG.error(this.getErrorMessage((Throwable)throwable, "Error reporting passing state to Consul: "), throwable);
                    }
                });
            } else {
                Mono failPublisher = Mono.from(this.consulClient.fail(checkId, status.getDescription().orElse(null)));
                failPublisher.subscribe(httpStatus -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Successfully reported failure state to Consul");
                    }
                }, throwable -> {
                    if (LOG.isErrorEnabled()) {
                        LOG.error(this.getErrorMessage((Throwable)throwable, "Error reporting failure state to Consul: "), throwable);
                    }
                });
            }
        }
    }

    protected void deregister(ServiceInstance instance) {
        ConsulConfiguration.ConsulRegistrationConfiguration registration = this.consulConfiguration.getRegistration();
        if (registration != null) {
            String applicationName = instance.getId();
            String serviceId = this.idGenerator.generateId(this.environment, instance);
            Publisher<HttpStatus> deregisterPublisher = this.consulClient.deregister(serviceId);
            String discoveryService = "Consul";
            this.performDeregistration("Consul", registration, deregisterPublisher, applicationName);
        }
    }

    protected void register(ServiceInstance instance) {
        ConsulConfiguration.ConsulRegistrationConfiguration registration = this.consulConfiguration.getRegistration();
        if (registration != null) {
            String applicationName = instance.getId();
            this.validateApplicationName(applicationName);
            if (StringUtils.isNotEmpty((CharSequence)applicationName)) {
                String address = this.address(instance, registration);
                HashMap<String, String> meta = new HashMap<String, String>(registration.getMeta());
                String serviceId = this.idGenerator.generateId(this.environment, instance);
                ConsulNewServiceEntry serviceEntry = new ConsulNewServiceEntry(applicationName, address, instance.getPort(), this.tags(instance, registration), serviceId, meta, this.createChecks(instance, registration, address));
                Publisher<HttpStatus> registerFlowable = this.consulClient.register(serviceEntry);
                this.performRegistration("Consul", registration, instance, registerFlowable);
            }
        }
    }

    @NonNull
    private List<String> tags(@NonNull ServiceInstance instance, @NonNull ConsulConfiguration.ConsulRegistrationConfiguration registration) {
        ArrayList<String> tags = new ArrayList<String>(registration.getTags());
        if (instance instanceof EmbeddedServerInstance) {
            EmbeddedServerInstance embeddedServerInstance = (EmbeddedServerInstance)instance;
            ApplicationConfiguration applicationConfiguration = embeddedServerInstance.getEmbeddedServer().getApplicationConfiguration();
            ApplicationConfiguration.InstanceConfiguration instanceConfiguration = applicationConfiguration.getInstance();
            instanceConfiguration.getGroup().ifPresent(g -> {
                this.validateName((String)g, "Instance Group");
                tags.add("group=" + g);
            });
            instanceConfiguration.getZone().ifPresent(z -> {
                this.validateName((String)z, "Instance Zone");
                tags.add("zone=" + z);
            });
            ConvertibleValues metadata = embeddedServerInstance.getMetadata();
            for (Map.Entry entry : metadata) {
                tags.add((String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        return tags;
    }

    @NonNull
    private List<ConsulCheck> createChecks(@NonNull ServiceInstance instance, @NonNull ConsulConfiguration.ConsulRegistrationConfiguration registration, String address) {
        ConsulConfiguration.ConsulRegistrationConfiguration.CheckConfiguration checkConfig = registration.getCheck();
        if (checkConfig.isEnabled()) {
            return Collections.singletonList(this.createCheck(checkConfig, instance, registration, address));
        }
        return Collections.emptyList();
    }

    private String address(@NonNull ServiceInstance instance, @NonNull ConsulConfiguration.ConsulRegistrationConfiguration registration) {
        String address = null;
        if (registration.isPreferIpAddress()) {
            address = registration.getIpAddr().orElseGet(() -> {
                String host = instance.getHost();
                try {
                    InetAddress inetAddress = InetAddress.getByName(host);
                    return inetAddress.getHostAddress();
                }
                catch (UnknownHostException e) {
                    throw new RegistrationException("Failed to lookup IP address for host [" + host + "]: " + e.getMessage(), (Throwable)e);
                }
            });
        }
        if (StringUtils.isEmpty(address)) {
            address = instance.getHost();
        }
        return address;
    }

    private ConsulCheck createCheck(@NonNull ConsulConfiguration.ConsulRegistrationConfiguration.CheckConfiguration checkConfig, @NonNull ServiceInstance instance, @NonNull ConsulConfiguration.ConsulRegistrationConfiguration registration, @Nullable String address) {
        ConsulCheck check = new ConsulCheck();
        check.setDeregisterCriticalServiceAfter(this.deregisterCriticalServiceAfterCheck(checkConfig));
        checkConfig.getId().ifPresent(check::setId);
        check.setStatus(DEFAULT_CHECK_STATUS);
        checkConfig.getNotes().ifPresent(check::setNotes);
        if (this.heartbeatConfiguration.isEnabled() && !checkConfig.isHttp()) {
            check.setTtl(this.heartbeatConfiguration.getInterval().plus(Duration.ofSeconds(10L)).toSeconds() + "s");
        } else {
            check.setInterval(this.checkInternal(checkConfig));
            this.httpCheckUrl(instance, registration, address).ifPresent(check::setHttp);
            check.setMethod(checkConfig.getMethod());
            checkConfig.getTlsSkipVerify().ifPresent(check::setTlsSkipVerify);
            check.setHeader(checkConfig.getHeaders());
        }
        return check;
    }

    @Nullable
    private String deregisterCriticalServiceAfterCheck(@NonNull ConsulConfiguration.ConsulRegistrationConfiguration.CheckConfiguration checkConfig) {
        return checkConfig.getDeregisterCriticalServiceAfter().map(d -> d.toMinutes() + "m").orElse(null);
    }

    @Nullable
    private String checkInternal(@NonNull ConsulConfiguration.ConsulRegistrationConfiguration.CheckConfiguration checkConfig) {
        return checkConfig.getInterval().toSeconds() + "s";
    }

    private Optional<URL> httpCheckUrl(@NonNull ServiceInstance instance, @NonNull ConsulConfiguration.ConsulRegistrationConfiguration registration, @Nullable String address) {
        if (instance instanceof EmbeddedServerInstance) {
            EmbeddedServerInstance embeddedServerInstance = (EmbeddedServerInstance)instance;
            EmbeddedServer embeddedServer = embeddedServerInstance.getEmbeddedServer();
            URL serverURL = embeddedServer.getURL();
            if (registration.isPreferIpAddress() && address != null) {
                try {
                    serverURL = new URL(embeddedServer.getURL().getProtocol(), address, embeddedServer.getPort(), embeddedServer.getURL().getPath());
                }
                catch (MalformedURLException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("invalid url for health check: {}:{}/{}", new Object[]{embeddedServer.getURL().getProtocol() + address, embeddedServer.getPort(), embeddedServer.getURL().getPath()});
                    }
                    throw new DiscoveryException("Invalid health path configured: " + registration.getHealthPath());
                }
            }
            try {
                return Optional.of(new URL(serverURL, registration.getHealthPath().orElse("/health")));
            }
            catch (MalformedURLException e) {
                throw new DiscoveryException("Invalid health path configured: " + registration.getHealthPath());
            }
        }
        return Optional.empty();
    }

    @Deprecated(forRemoval=true, since="4.1.0")
    protected void customizeServiceEntry(ServiceInstance instance, ConsulNewServiceEntry serviceEntry) {
    }
}

