/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.eureka;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.DiscoveryConfiguration;
import io.micronaut.discovery.client.DiscoveryClientConfiguration;
import io.micronaut.discovery.eureka.client.v2.DataCenterInfo;
import io.micronaut.discovery.eureka.client.v2.InstanceInfo;
import io.micronaut.discovery.eureka.client.v2.LeaseInfo;
import io.micronaut.discovery.registration.RegistrationConfiguration;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import jakarta.inject.Inject;
import java.net.InetAddress;
import java.net.UnknownHostException;

@ConfigurationProperties(value="eureka.client")
@Requires(property="eureka.client")
public class EurekaConfiguration
extends DiscoveryClientConfiguration {
    public static final String PREFIX = "eureka.client";
    public static final String CONTEXT_PATH = "eureka.client.context-path";
    public static final String CONTEXT_PATH_PLACEHOLDER = "${eureka.client.context-path:/eureka}";
    public static final String HOST = "eureka.client.host";
    public static final String PORT = "eureka.client.port";
    private static final int EUREKA_DEFAULT_PORT = 8761;
    private final HttpClientConfiguration.ConnectionPoolConfiguration eurekaConnectionPoolConfiguration;
    private EurekaDiscoveryConfiguration discovery = new EurekaDiscoveryConfiguration();
    private EurekaRegistrationConfiguration registration;

    public EurekaConfiguration(EurekaConnectionPoolConfiguration eurekaConnectionPoolConfiguration, ApplicationConfiguration applicationConfiguration, @Nullable EurekaRegistrationConfiguration eurekaRegistrationConfiguration) {
        super(applicationConfiguration);
        this.registration = eurekaRegistrationConfiguration;
        this.eurekaConnectionPoolConfiguration = eurekaConnectionPoolConfiguration;
        this.setPort(8761);
    }

    @Override
    @NonNull
    public EurekaDiscoveryConfiguration getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(EurekaDiscoveryConfiguration discovery) {
        if (discovery != null) {
            this.discovery = discovery;
        }
    }

    @Override
    @Nullable
    public EurekaRegistrationConfiguration getRegistration() {
        return this.registration;
    }

    public boolean shouldLogAmazonMetadataErrors() {
        return true;
    }

    @Override
    protected String getServiceID() {
        return "eureka";
    }

    public HttpClientConfiguration.ConnectionPoolConfiguration getConnectionPoolConfiguration() {
        return this.eurekaConnectionPoolConfiguration;
    }

    @ConfigurationProperties(value="discovery")
    @Requires(property="eureka.client")
    public static class EurekaDiscoveryConfiguration
    extends DiscoveryConfiguration {
        private boolean useSecurePort;

        public boolean isUseSecurePort() {
            return this.useSecurePort;
        }

        public void setUseSecurePort(boolean useSecurePort) {
            this.useSecurePort = useSecurePort;
        }
    }

    @ConfigurationProperties(value="registration")
    @Requirements(value={@Requires(property="micronaut.application.name"), @Requires(property="eureka.client")})
    public static class EurekaRegistrationConfiguration
    extends RegistrationConfiguration {
        public static final String PREFIX = "eureka.client.registration";
        public static final String IP_ADDRESS = "eureka.client.registration.ip-addr";
        public static final String PREFER_IP_ADDRESS = "eureka.client.registration.prefer-ip-address";
        public static final String APPNAME = "eureka.client.registration.appname";
        public static final String INSTANCE_ID = "eureka.client.registration.instance-id";
        public static final String HOSTNAME = "eureka.client.registration.hostname";
        public static final String PORT = "eureka.client.registration.port";
        @ConfigurationBuilder
        InstanceInfo instanceInfo;
        @ConfigurationBuilder(configurationPrefix="lease-info")
        LeaseInfo.Builder leaseInfo = LeaseInfo.Builder.newBuilder();
        private final boolean explicitInstanceId;

        @Inject
        public EurekaRegistrationConfiguration(EmbeddedServer embeddedServer, ApplicationConfiguration applicationConfiguration, @Nullable DataCenterInfo dataCenterInfo, @Property(name="eureka.client.registration.appname") @Nullable String appName, @Property(name="eureka.client.registration.hostname") @Nullable String hostname, @Property(name="eureka.client.registration.port") @Nullable Integer port, @Property(name="eureka.client.registration.ip-addr") @Nullable String ipAddr, @Property(name="eureka.client.registration.instance-id") @Nullable String instanceId, @Property(name="eureka.client.registration.prefer-ip-address") @Nullable Boolean preferIpAddress) {
            if (preferIpAddress == null) {
                preferIpAddress = false;
            }
            if (StringUtils.isEmpty((CharSequence)appName)) {
                appName = applicationConfiguration.getName().orElse("application");
            }
            if (StringUtils.isEmpty((CharSequence)hostname)) {
                hostname = embeddedServer.getHost();
            }
            if (StringUtils.isEmpty((CharSequence)ipAddr)) {
                ipAddr = EurekaRegistrationConfiguration.lookupIp(hostname);
            }
            if (port == null) {
                port = embeddedServer.getPort();
            }
            boolean bl = this.explicitInstanceId = StringUtils.isNotEmpty((CharSequence)instanceId) || preferIpAddress != false;
            if (!this.explicitInstanceId || StringUtils.isEmpty((CharSequence)instanceId)) {
                String appHostname = preferIpAddress != false ? ipAddr : hostname;
                instanceId = appHostname + ":" + appName + ":" + port;
            }
            this.instanceInfo = this.createInstanceInfo(appName, (String)instanceId, hostname, ipAddr, port, preferIpAddress);
            if (dataCenterInfo != null) {
                this.instanceInfo.setDataCenterInfo(dataCenterInfo);
            }
        }

        private InstanceInfo createInstanceInfo(String appName, String instanceId, String hostname, String ipAddr, int port, boolean preferIpAddress) {
            String appHostname = preferIpAddress ? ipAddr : hostname;
            return new InstanceInfo(appHostname, port, ipAddr, appName, instanceId);
        }

        public boolean isExplicitInstanceId() {
            return this.explicitInstanceId;
        }

        public InstanceInfo getInstanceInfo() {
            LeaseInfo leaseInfo = this.leaseInfo.build();
            this.instanceInfo.setLeaseInfo(leaseInfo);
            return this.instanceInfo;
        }

        private static String lookupIp(String host) {
            try {
                return InetAddress.getByName(host).getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Unable to lookup host IP address: " + host, e);
            }
        }
    }

    @ConfigurationProperties(value="pool")
    public static class EurekaConnectionPoolConfiguration
    extends HttpClientConfiguration.ConnectionPoolConfiguration {
    }
}

