/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.eureka.health;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.discovery.eureka.client.v2.EurekaClient;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import jakarta.inject.Singleton;
import java.util.Collections;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
@Requirements(value={@Requires(classes={HealthIndicator.class}), @Requires(beans={EurekaClient.class})})
public class EurekaHealthIndicator
implements HealthIndicator {
    private final EurekaClient eurekaClient;

    public EurekaHealthIndicator(EurekaClient eurekaClient) {
        this.eurekaClient = eurekaClient;
    }

    public Publisher<HealthResult> getResult() {
        Flux serviceIds = Flux.from((Publisher)this.eurekaClient.getServiceIds());
        return serviceIds.map(ids -> {
            HealthResult.Builder builder = HealthResult.builder((String)"eureka", (HealthStatus)HealthStatus.UP);
            return builder.details(Collections.singletonMap("available-services", ids)).build();
        }).onErrorResume(throwable -> {
            HealthResult.Builder builder = HealthResult.builder((String)"eureka", (HealthStatus)HealthStatus.DOWN);
            builder.exception(throwable);
            return Flux.just((Object)builder.build());
        });
    }
}

