/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.client;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.discovery.client.DiscoveryClientConfiguration;
import io.micronaut.discovery.client.DnsResolver;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class EndpointUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointUtil.class);
    private static final String DEFAULT_REGION = "default";
    private static final String DEFAULT_ZONE = "default";

    public static List<String> getServiceUrlsFromDNS(EmbeddedServer embeddedServer, ApplicationConfiguration.InstanceConfiguration instanceConfiguration, DiscoveryClientConfiguration discoveryClientConfiguration) {
        return EndpointUtil.getServiceUrlsFromDNS(instanceConfiguration, discoveryClientConfiguration, instanceConfiguration.getZone().orElse("default"), true, new InstanceInfoBasedUrlRandomizer(embeddedServer));
    }

    private static List<String> getServiceUrlsFromDNS(ApplicationConfiguration.InstanceConfiguration serviceInstance, DiscoveryClientConfiguration discoveryClientConfiguration, String instanceZone, boolean preferSameZone, ServiceUrlRandomizer randomizer) {
        ConvertibleValues values = ConvertibleValues.of((Map)serviceInstance.getMetadata());
        String region = values.get((CharSequence)"region", String.class).orElse("default");
        Map<String, List<String>> zoneDnsNamesMap = EndpointUtil.getZoneBasedDiscoveryUrlsFromRegion(discoveryClientConfiguration, region);
        Set<String> availableZones = zoneDnsNamesMap.keySet();
        ArrayList<String> zones = new ArrayList<String>(availableZones);
        if (zones.isEmpty()) {
            throw new RuntimeException("No available zones configured for the instanceZone " + instanceZone);
        }
        int zoneIndex = 0;
        boolean zoneFound = false;
        for (String string : zones) {
            LOG.debug("Checking if the instance zone {} is the same as the zone from DNS {}", (Object)instanceZone, (Object)string);
            if (preferSameZone) {
                if (instanceZone.equalsIgnoreCase(string)) {
                    zoneFound = true;
                }
            } else if (!instanceZone.equalsIgnoreCase(string)) {
                zoneFound = true;
            }
            if (zoneFound) {
                LOG.debug("The zone index from the list {} that matches the instance zone {} is {}", new Object[]{zones, instanceZone, zoneIndex});
                break;
            }
            ++zoneIndex;
        }
        if (zoneIndex >= zones.size()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("No match for the zone {} in the list of available zones {}", (Object)instanceZone, (Object)zones.toArray());
            }
        } else {
            for (int i = 0; i < zoneIndex; ++i) {
                String string = (String)zones.remove(0);
                zones.add(string);
            }
        }
        ArrayList<String> serviceUrls = new ArrayList<String>();
        for (String zone : zones) {
            for (String zoneCname : zoneDnsNamesMap.get(zone)) {
                ArrayList<String> ec2Urls = new ArrayList<String>(EndpointUtil.getEC2DiscoveryUrlsFromZone(zoneCname, DiscoveryUrlType.CNAME));
                if (ec2Urls.size() > 1) {
                    randomizer.randomize(ec2Urls);
                }
                for (String ec2Url : ec2Urls) {
                    StringBuilder sb = new StringBuilder().append("http://").append(ec2Url).append(":").append(discoveryClientConfiguration.getPort());
                    Optional<String> contextPath = discoveryClientConfiguration.getContextPath();
                    if (contextPath.isPresent()) {
                        String path = contextPath.get();
                        if (!path.startsWith("/")) {
                            sb.append('/');
                        }
                        sb.append(path);
                        if (!path.endsWith("/")) {
                            sb.append('/');
                        }
                    } else {
                        sb.append('/');
                    }
                    String serviceUrl = sb.toString();
                    LOG.debug("The EC2 url is {}", (Object)serviceUrl);
                    serviceUrls.add(serviceUrl);
                }
            }
        }
        String string = (String)serviceUrls.remove(0);
        randomizer.randomize(serviceUrls);
        serviceUrls.add(0, string);
        if (LOG.isDebugEnabled()) {
            LOG.debug("This client will talk to the following serviceUrls in order : {} ", (Object)serviceUrls.toArray());
        }
        return serviceUrls;
    }

    private static Set<String> getEC2DiscoveryUrlsFromZone(String dnsName, DiscoveryUrlType type) {
        TreeSet<String> eipsForZone;
        try {
            dnsName = "txt." + (String)dnsName;
            LOG.debug("The zone url to be looked up is {} :", dnsName);
            Set<String> ec2UrlsForZone = DnsResolver.getCNamesFromTxtRecord((String)dnsName);
            for (String ec2Url : ec2UrlsForZone) {
                LOG.debug("The eureka url for the dns name {} is {}", dnsName, (Object)ec2Url);
                ec2UrlsForZone.add(ec2Url);
            }
            if (DiscoveryUrlType.CNAME.equals((Object)type)) {
                return ec2UrlsForZone;
            }
            eipsForZone = new TreeSet<String>();
            for (String cname : ec2UrlsForZone) {
                String[] tokens = cname.split("\\.");
                String ec2HostName = tokens[0];
                String[] ips = ec2HostName.split("-");
                StringBuilder eipBuffer = new StringBuilder();
                for (int ipCtr = 1; ipCtr < 5; ++ipCtr) {
                    eipBuffer.append(ips[ipCtr]);
                    if (ipCtr >= 4) continue;
                    eipBuffer.append('.');
                }
                eipsForZone.add(eipBuffer.toString());
            }
            LOG.debug("The EIPS for {} is {} :", dnsName, eipsForZone);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot get cnames bound to the region:" + (String)dnsName, e);
        }
        return eipsForZone;
    }

    private static Map<String, List<String>> getZoneBasedDiscoveryUrlsFromRegion(DiscoveryClientConfiguration discoveryClientConfiguration, String region) {
        String discoveryDnsName = null;
        try {
            discoveryDnsName = "txt." + region + "." + discoveryClientConfiguration.getHost();
            LOG.debug("The region url to be looked up is {} :", (Object)discoveryDnsName);
            TreeSet<String> zoneCnamesForRegion = new TreeSet<String>(DnsResolver.getCNamesFromTxtRecord(discoveryDnsName));
            TreeMap<String, List<String>> zoneCnameMapForRegion = new TreeMap<String, List<String>>();
            for (String zoneCname : zoneCnamesForRegion) {
                if (EndpointUtil.isEC2Url(zoneCname)) {
                    throw new RuntimeException("Cannot find the right DNS entry for " + discoveryDnsName + ". Expected mapping of the format <aws_zone>.<domain_name>");
                }
                String[] cnameTokens = zoneCname.split("\\.");
                String zone = cnameTokens[0];
                LOG.debug("The zoneName mapped to region {} is {}", (Object)region, (Object)zone);
                List zoneCnamesSet = zoneCnameMapForRegion.computeIfAbsent(zone, k -> new ArrayList());
                zoneCnamesSet.add(zoneCname);
            }
            return zoneCnameMapForRegion;
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot get cnames bound to the region:" + discoveryDnsName, e);
        }
    }

    private static boolean isEC2Url(String zoneCname) {
        return zoneCname.startsWith("ec2");
    }

    private record InstanceInfoBasedUrlRandomizer(EmbeddedServer instanceInfo) implements ServiceUrlRandomizer
    {
        @Override
        public void randomize(List<String> urlList) {
            int listSize = 0;
            if (urlList != null) {
                listSize = urlList.size();
            }
            if (this.instanceInfo == null || listSize == 0) {
                return;
            }
            int instanceHashcode = this.instanceInfo.getHost().hashCode();
            if (instanceHashcode < 0) {
                instanceHashcode *= -1;
            }
            int backupInstance = instanceHashcode % listSize;
            for (int i = 0; i < backupInstance; ++i) {
                String zone = urlList.remove(0);
                urlList.add(zone);
            }
        }
    }

    private static interface ServiceUrlRandomizer {
        public void randomize(List<String> var1);
    }

    private static enum DiscoveryUrlType {
        CNAME,
        A;

    }
}

