/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.Toggleable;
import io.micronaut.discovery.DiscoveryConfiguration;
import io.micronaut.discovery.client.DiscoveryClientConfiguration;
import io.micronaut.discovery.config.ConfigDiscoveryConfiguration;
import io.micronaut.discovery.consul.condition.RequiresConsul;
import io.micronaut.discovery.registration.RegistrationConfiguration;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@RequiresConsul
@ConfigurationProperties(value="consul.client")
@BootstrapContextCompatible
@Requires(property="consul.client")
public class ConsulConfiguration
extends DiscoveryClientConfiguration {
    public static final String PREFIX = "consul.client";
    private static final int CONSULT_DEFAULT_PORT = 8500;
    private final ConsulConnectionPoolConfiguration consulConnectionPoolConfiguration;
    private String aslToken;
    private boolean healthCheck = true;
    private ConsulRegistrationConfiguration registration = new ConsulRegistrationConfiguration();
    private ConsulDiscoveryConfiguration discovery = new ConsulDiscoveryConfiguration();
    private ConsulConfigDiscoveryConfiguration configuration = new ConsulConfigDiscoveryConfiguration();

    public ConsulConfiguration() {
        this.setPort(8500);
        this.consulConnectionPoolConfiguration = new ConsulConnectionPoolConfiguration();
    }

    @Inject
    public ConsulConfiguration(ConsulConnectionPoolConfiguration consulConnectionPoolConfiguration, ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
        this.setPort(8500);
        this.consulConnectionPoolConfiguration = consulConnectionPoolConfiguration;
    }

    public boolean isHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(boolean healthCheck) {
        this.healthCheck = healthCheck;
    }

    public HttpClientConfiguration.ConnectionPoolConfiguration getConnectionPoolConfiguration() {
        return this.consulConnectionPoolConfiguration;
    }

    public ConsulConfigDiscoveryConfiguration getConfiguration() {
        return this.configuration;
    }

    @Inject
    public void setConfiguration(ConsulConfigDiscoveryConfiguration configuration) {
        if (configuration != null) {
            this.configuration = configuration;
        }
    }

    public Optional<String> getAslToken() {
        return Optional.ofNullable(this.aslToken);
    }

    public void setAslToken(String aslToken) {
        this.aslToken = aslToken;
    }

    @Override
    public ConsulRegistrationConfiguration getRegistration() {
        return this.registration;
    }

    @Inject
    public void setRegistration(ConsulRegistrationConfiguration registration) {
        if (registration != null) {
            this.registration = registration;
        }
    }

    @Override
    public ConsulDiscoveryConfiguration getDiscovery() {
        return this.discovery;
    }

    @Inject
    public void setDiscovery(ConsulDiscoveryConfiguration discovery) {
        if (discovery != null) {
            this.discovery = discovery;
        }
    }

    @Override
    protected String getServiceID() {
        return "consul";
    }

    @Override
    public String toString() {
        return "ConsulConfiguration{aslToken='" + this.aslToken + "', registration=" + this.registration + ", discovery=" + this.discovery + "} " + super.toString();
    }

    @ConfigurationProperties(value="registration")
    @BootstrapContextCompatible
    public static class ConsulRegistrationConfiguration
    extends RegistrationConfiguration {
        public static final String PREFIX = "consul.client.registration";
        private List<String> tags = Collections.emptyList();
        private Map<String, String> meta = Collections.emptyMap();
        private CheckConfiguration check = new CheckConfiguration();

        public List<String> getTags() {
            return this.tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        public Map<String, String> getMeta() {
            return this.meta;
        }

        public void setMeta(Map<String, String> meta) {
            this.meta = meta;
        }

        public CheckConfiguration getCheck() {
            return this.check;
        }

        public void setCheck(CheckConfiguration check) {
            this.check = check;
        }

        public String toString() {
            return "ConsulRegistrationConfiguration{tags=" + this.tags + ", meta=" + this.meta + ", check=" + this.check + "}";
        }

        @ConfigurationProperties(value="check")
        @BootstrapContextCompatible
        public static class CheckConfiguration
        implements Toggleable {
            public static final boolean DEFAULT_ENABLED = true;
            public static final boolean DEFAULT_HTTP = false;
            public static final int DEFAULT_INTERVAL_SECONDS = 15;
            private HttpMethod method = HttpMethod.GET;
            private Duration interval = Duration.ofSeconds(15L);
            private Map<CharSequence, List<String>> headers = Collections.emptyMap();
            private Duration deregisterCriticalServiceAfter;
            private String notes;
            private String id;
            private Boolean tlsSkipVerify;
            private boolean enabled = true;
            private boolean http = false;

            public Duration getInterval() {
                return this.interval;
            }

            public void setInterval(Duration interval) {
                this.interval = interval;
            }

            public boolean isHttp() {
                return this.http;
            }

            public void setHttp(boolean http) {
                this.http = http;
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public Optional<Duration> getDeregisterCriticalServiceAfter() {
                return Optional.ofNullable(this.deregisterCriticalServiceAfter);
            }

            public void setDeregisterCriticalServiceAfter(Duration deregisterCriticalServiceAfter) {
                this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
            }

            public Optional<String> getId() {
                return Optional.ofNullable(this.id);
            }

            public void setId(String id) {
                this.id = id;
            }

            public Optional<String> getNotes() {
                return Optional.ofNullable(this.notes);
            }

            public void setNotes(String notes) {
                this.notes = notes;
            }

            public Optional<Boolean> getTlsSkipVerify() {
                return Optional.ofNullable(this.tlsSkipVerify);
            }

            public void setTlsSkipVerify(Boolean tlsSkipVerify) {
                this.tlsSkipVerify = tlsSkipVerify;
            }

            public HttpMethod getMethod() {
                return this.method;
            }

            public void setMethod(HttpMethod method) {
                this.method = method;
            }

            public Map<CharSequence, List<String>> getHeaders() {
                return this.headers;
            }

            public void setHeaders(Map<CharSequence, List<String>> headers) {
                this.headers = headers;
            }

            public String toString() {
                return "CheckConfiguration{method=" + this.method + ", headers=" + this.headers + ", deregisterCriticalServiceAfter=" + this.deregisterCriticalServiceAfter + ", notes='" + this.notes + "', id='" + this.id + "', tlsSkipVerify=" + this.tlsSkipVerify + ", enabled=" + this.enabled + "}";
            }
        }
    }

    @ConfigurationProperties(value="discovery")
    @BootstrapContextCompatible
    @Requires(property="consul.client")
    public static class ConsulDiscoveryConfiguration
    extends DiscoveryConfiguration {
        private Map<String, String> tags = Collections.emptyMap();
        private Map<String, String> schemes = Collections.emptyMap();
        private Map<String, String> datacenters = Collections.emptyMap();
        private boolean passing = false;

        public boolean isPassing() {
            return this.passing;
        }

        public void setPassing(boolean passing) {
            this.passing = passing;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public void setTags(Map<String, String> tags) {
            if (tags != null) {
                this.tags = tags;
            }
        }

        public Map<String, String> getDatacenters() {
            return this.datacenters;
        }

        public void setDatacenters(Map<String, String> datacenters) {
            if (datacenters != null) {
                this.datacenters = datacenters;
            }
        }

        public Map<String, String> getSchemes() {
            return this.schemes;
        }

        public void setSchemes(Map<String, String> schemes) {
            this.schemes = schemes;
        }

        public String toString() {
            return "ConsulDiscoveryConfiguration{tags=" + this.tags + ", datacenters=" + this.datacenters + ", passing=" + this.passing + "}";
        }
    }

    @ConfigurationProperties(value="config")
    @BootstrapContextCompatible
    @Requires(property="consul.client")
    public static class ConsulConfigDiscoveryConfiguration
    extends ConfigDiscoveryConfiguration {
        public static final String PREFIX = "consul.client.config";
        private String datacenter;

        public Optional<String> getDatacenter() {
            return Optional.ofNullable(this.datacenter);
        }

        public void setDatacenter(String datacenter) {
            this.datacenter = datacenter;
        }
    }

    @ConfigurationProperties(value="pool")
    @BootstrapContextCompatible
    public static class ConsulConnectionPoolConfiguration
    extends HttpClientConfiguration.ConnectionPoolConfiguration {
    }
}

