/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.consul.client.v1.ConsulCatalogEntry;
import io.micronaut.discovery.consul.client.v1.ConsulCheck;
import io.micronaut.discovery.consul.client.v1.ConsulCheckStatus;
import io.micronaut.discovery.consul.client.v1.ConsulHealthEntry;
import io.micronaut.discovery.consul.client.v1.ConsulServiceEntry;
import io.micronaut.discovery.consul.client.v1.HealthEntry;
import io.micronaut.discovery.exceptions.DiscoveryException;
import io.micronaut.health.HealthStatus;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class ConsulServiceInstance
implements ServiceInstance {
    private final ConsulHealthEntry healthEntry;
    private final URI uri;
    private ConvertibleValues<String> metadata;

    public ConsulServiceInstance(@NonNull ConsulHealthEntry healthEntry, @Nullable String scheme) {
        Objects.requireNonNull(healthEntry, "ConsulHealthEntry cannot be null");
        this.healthEntry = healthEntry;
        ConsulServiceEntry service = healthEntry.service();
        Objects.requireNonNull(service, "ConsulHealthEntry cannot reference a null service entry");
        ConsulCatalogEntry node = healthEntry.node();
        Objects.requireNonNull(service, "ConsulHealthEntry cannot reference a null node entry");
        String inetAddress = service.address() != null ? service.address() : node.address().getHostAddress();
        int port = service.port() != null ? service.port() : -1;
        Object portSuffix = port > -1 ? ":" + port : "";
        String uriStr = (String)(scheme != null ? scheme + "://" : "http://") + inetAddress + (String)portSuffix;
        try {
            this.uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new DiscoveryException("Invalid service URI: " + uriStr);
        }
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public ConsulServiceInstance(@NonNull HealthEntry healthEntry, @Nullable String scheme) {
        this.healthEntry = null;
        this.uri = null;
    }

    public HealthStatus getHealthStatus() {
        Stream<ConsulCheck> criticalStream;
        Optional<ConsulCheck> first;
        List<ConsulCheck> checks = this.healthEntry.checks();
        if (CollectionUtils.isNotEmpty(checks) && (first = (criticalStream = checks.stream().filter(c -> c.getStatus().equals(ConsulCheckStatus.CRITICAL.toString()))).findFirst()).isPresent()) {
            ConsulCheck check = first.get();
            String notes = check.getNotes();
            if (StringUtils.isNotEmpty((CharSequence)notes)) {
                return HealthStatus.DOWN.describe(notes);
            }
            return HealthStatus.DOWN;
        }
        return HealthStatus.UP;
    }

    @Deprecated(forRemoval=true, since="4.1.0")
    public HealthEntry getHealthEntry() {
        return null;
    }

    public String getId() {
        return this.healthEntry.service().id();
    }

    public Optional<String> getInstanceId() {
        return Optional.ofNullable(this.healthEntry.service().id());
    }

    public URI getURI() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConvertibleValues<String> getMetadata() {
        ConvertibleValues<String> metadata = this.metadata;
        if (metadata == null) {
            ConsulServiceInstance consulServiceInstance = this;
            synchronized (consulServiceInstance) {
                metadata = this.metadata;
                if (metadata == null) {
                    this.metadata = metadata = this.buildMetadata();
                }
            }
        }
        return metadata;
    }

    private ConvertibleValues<String> buildMetadata() {
        Map<String, String> meta;
        LinkedHashMap<String, String> map = this.healthEntry.node().nodeMetadata() != null ? new LinkedHashMap<String, String>(this.healthEntry.node().nodeMetadata()) : new LinkedHashMap();
        List<String> tags = this.healthEntry.service().tags();
        if (tags != null) {
            for (String tag : tags) {
                int i = tag.indexOf(61);
                if (i <= -1) continue;
                map.put(tag.substring(0, i), tag.substring(i + 1));
            }
        }
        if ((meta = this.healthEntry.service().meta()) != null) {
            map.putAll(meta);
        }
        return ConvertibleValues.of(map);
    }
}

