/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.health;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.discovery.consul.client.v1.ConsulClient;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import jakarta.inject.Singleton;
import java.util.Collections;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
@Requirements(value={@Requires(classes={HealthIndicator.class}), @Requires(beans={ConsulClient.class}), @Requires(property="consul.client.health-check", value="true", defaultValue="true")})
public class ConsulHealthIndicator
implements HealthIndicator {
    private final ConsulClient client;

    public ConsulHealthIndicator(ConsulClient client) {
        this.client = client;
    }

    public Publisher<HealthResult> getResult() {
        Flux statusFlowable = Flux.from(this.client.status());
        return statusFlowable.map(s -> {
            HealthResult.Builder builder = HealthResult.builder((String)"consul", (HealthStatus)HealthStatus.UP);
            builder.details(Collections.singletonMap("leader", s));
            return builder.build();
        }).onErrorResume(throwable -> {
            HealthResult.Builder builder = HealthResult.builder((String)"consul", (HealthStatus)HealthStatus.DOWN);
            builder.exception(throwable);
            return Flux.just((Object)builder.build());
        });
    }
}

