/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.eureka.client.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.eureka.client.v2.AmazonInfo;
import io.micronaut.discovery.eureka.client.v2.ConfigurableInstanceInfo;
import io.micronaut.discovery.eureka.client.v2.DataCenterInfo;
import io.micronaut.discovery.eureka.client.v2.LeaseInfo;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@JsonRootName(value="instance")
@Serdeable
public class InstanceInfo
implements ConfigurableInstanceInfo {
    public static final int DEFAULT_PORT = 7001;
    public static final int DEFAULT_SECURE_PORT = 0;
    public static final int DEFAULT_COUNTRY_ID = 1;
    private String asgName;
    private String hostName;
    private String app;
    private String instanceId;
    private String ipAddr;
    private String appGroupName;
    private String vipAddress;
    private String secureVipAddress;
    private Status status = Status.UP;
    private int port = 7001;
    private int securePort = 0;
    private int countryId = 1;
    private String homePageUrl;
    private String statusPageUrl;
    private String healthCheckUrl;
    private String secureHealthCheckUrl;
    private DataCenterInfo dataCenterInfo = () -> DataCenterInfo.Name.MyOwn;
    private LeaseInfo leaseInfo;
    private Map<String, String> metadata = new ConcurrentHashMap<String, String>();

    @JsonCreator
    InstanceInfo(@JsonProperty(value="instanceId") String instanceId, @JsonProperty(value="app") String appName, @JsonProperty(value="appGroupName") String appGroupName, @JsonProperty(value="ipAddr") String ipAddr, @JsonProperty(value="port") PortWrapper port, @JsonProperty(value="securePort") PortWrapper securePort, @JsonProperty(value="homePageUrl") String homePageUrl, @JsonProperty(value="statusPageUrl") String statusPageUrl, @JsonProperty(value="healthCheckUrl") String healthCheckUrl, @JsonProperty(value="secureHealthCheckUrl") String secureHealthCheckUrl, @JsonProperty(value="vipAddress") String vipAddress, @JsonProperty(value="secureVipAddress") String secureVipAddress, @JsonProperty(value="countryId") int countryId, @JsonProperty(value="dataCenterInfo") DataCenterInfo dataCenterInfo, @JsonProperty(value="hostName") String hostName, @JsonProperty(value="status") Status status, @JsonProperty(value="overriddenstatus") Status overriddenstatus, @JsonProperty(value="leaseInfo") LeaseInfo leaseInfo, @JsonProperty(value="metadata") HashMap<String, String> metadata, @JsonProperty(value="asgName") String asgName) {
        this.instanceId = instanceId;
        this.app = appName;
        this.appGroupName = appGroupName;
        this.ipAddr = ipAddr;
        this.port = port == null ? 0 : port.getPort();
        this.securePort = securePort == null ? 0 : securePort.getPort();
        this.homePageUrl = homePageUrl;
        this.statusPageUrl = statusPageUrl;
        this.healthCheckUrl = healthCheckUrl;
        this.secureHealthCheckUrl = secureHealthCheckUrl;
        this.vipAddress = vipAddress;
        this.secureVipAddress = secureVipAddress;
        this.countryId = countryId;
        this.dataCenterInfo = dataCenterInfo;
        this.hostName = hostName;
        this.status = status;
        this.leaseInfo = leaseInfo;
        this.asgName = asgName;
        this.metadata = Objects.requireNonNullElse(metadata, Collections.emptyMap());
    }

    public InstanceInfo(String host, @NotBlank String appName, @NotBlank String instanceId) {
        this(host, 7001, appName, instanceId);
    }

    public InstanceInfo(String host, @NotBlank String appName) {
        this(host, 7001, appName, host);
    }

    public InstanceInfo(String host, int port, @NotBlank String appName, @NotBlank String instanceId) {
        this(host, port, InstanceInfo.lookupIp(host), appName, instanceId);
    }

    public InstanceInfo(String host, int port, String ipAddress, String appName, String instanceId) {
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("Argument [hostName] cannot be null or blank");
        }
        if (StringUtils.isEmpty((CharSequence)appName)) {
            throw new IllegalArgumentException("Argument [appName] cannot be null or blank");
        }
        if (StringUtils.isEmpty((CharSequence)instanceId)) {
            throw new IllegalArgumentException("Argument [instanceId] cannot be null or blank");
        }
        if (StringUtils.isEmpty((CharSequence)ipAddress)) {
            throw new IllegalArgumentException("Argument [ipAddress] cannot be null or blank");
        }
        this.hostName = host;
        this.port = port;
        this.ipAddr = ipAddress;
        this.app = appName;
        this.instanceId = instanceId;
    }

    public String toString() {
        return this.getId();
    }

    @Override
    @NotBlank
    public String getHostName() {
        return this.hostName;
    }

    @Override
    @JsonIgnore
    public String getId() {
        AmazonInfo amazonInfo;
        String uniqueId;
        if (this.instanceId != null && !this.instanceId.isEmpty()) {
            return this.instanceId;
        }
        DataCenterInfo dataCenterInfo = this.dataCenterInfo;
        if (dataCenterInfo instanceof AmazonInfo && (uniqueId = (amazonInfo = (AmazonInfo)dataCenterInfo).getId()) != null && !uniqueId.isEmpty()) {
            return uniqueId;
        }
        return this.hostName;
    }

    @Override
    @JsonIgnore
    public int getPort() {
        return this.port;
    }

    @Override
    @JsonIgnore
    public int getSecurePort() {
        return this.securePort;
    }

    @JsonProperty(value="port")
    public PortWrapper getPortWrapper() {
        if (this.port < 1) {
            return new PortWrapper(false, 0);
        }
        return new PortWrapper(true, this.port);
    }

    @JsonProperty(value="securePort")
    public PortWrapper getSecurePortWrapper() {
        if (this.securePort < 1) {
            return new PortWrapper(false, 0);
        }
        return new PortWrapper(true, this.securePort);
    }

    @Override
    public void setSecurePort(int securePort) {
        this.securePort = securePort;
    }

    @Override
    public void setPort(int port) {
        if (port >= 0) {
            this.port = port;
        }
    }

    @Override
    @NotBlank
    public String getApp() {
        return this.app;
    }

    @Override
    public String getAppGroupName() {
        return this.appGroupName;
    }

    @Override
    @NotBlank
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    @Min(value=1L)
    public @Min(value=1L) int getCountryId() {
        return this.countryId;
    }

    @Override
    @NotBlank
    public String getIpAddr() {
        return this.ipAddr;
    }

    @Override
    @NotNull
    public Status getStatus() {
        return this.status;
    }

    @Override
    @NotNull
    public DataCenterInfo getDataCenterInfo() {
        return this.dataCenterInfo;
    }

    @Override
    public LeaseInfo getLeaseInfo() {
        return this.leaseInfo;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getStatusPageUrl() {
        if (this.statusPageUrl == null) {
            return this.getHealthCheckUrl();
        }
        return this.statusPageUrl;
    }

    @Override
    public String getHomePageUrl() {
        if (this.homePageUrl == null) {
            return "http://" + this.hostName + this.portString();
        }
        return this.homePageUrl;
    }

    @Override
    public String getHealthCheckUrl() {
        return Objects.requireNonNullElseGet(this.healthCheckUrl, () -> "http://" + this.hostName + this.portString() + "/health");
    }

    @Override
    @NotBlank
    public String getVipAddress() {
        if (this.vipAddress == null) {
            return this.app;
        }
        return this.vipAddress;
    }

    @Override
    @NotBlank
    public String getSecureVipAddress() {
        if (this.secureVipAddress == null) {
            return this.app;
        }
        return this.secureVipAddress;
    }

    @Override
    public String getSecureHealthCheckUrl() {
        return Objects.requireNonNullElseGet(this.secureHealthCheckUrl, () -> "https://" + this.hostName + this.securePortString() + "/health");
    }

    @Override
    public String getAsgName() {
        return this.asgName;
    }

    @Override
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public void setAsgName(String asgName) {
        this.asgName = asgName;
    }

    @Override
    public void setHomePageUrl(String homePageUrl) {
        if (!StringUtils.isEmpty((CharSequence)homePageUrl)) {
            this.homePageUrl = homePageUrl;
        }
    }

    @Override
    public void setLeaseInfo(LeaseInfo leaseInfo) {
        this.leaseInfo = leaseInfo;
    }

    @Override
    public void setCountryId(int countryId) {
        if (countryId > 0) {
            this.countryId = countryId;
        }
    }

    @Override
    public void setStatusPageUrl(String statusPageUrl) {
        if (!StringUtils.isEmpty((CharSequence)statusPageUrl)) {
            this.statusPageUrl = statusPageUrl;
        }
    }

    @Override
    public void setHealthCheckUrl(String healthCheckUrl) {
        if (!StringUtils.isEmpty((CharSequence)healthCheckUrl)) {
            this.healthCheckUrl = healthCheckUrl;
        }
    }

    @Override
    public void setSecureHealthCheckUrl(String secureHealthCheckUrl) {
        if (!StringUtils.isEmpty((CharSequence)secureHealthCheckUrl)) {
            this.secureHealthCheckUrl = secureHealthCheckUrl;
        }
    }

    @Override
    public void setDataCenterInfo(DataCenterInfo dataCenterInfo) {
        if (dataCenterInfo != null) {
            this.dataCenterInfo = dataCenterInfo;
        }
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.status = status;
        }
    }

    @Override
    public void setAppGroupName(String appGroupName) {
        if (StringUtils.isNotEmpty((CharSequence)appGroupName)) {
            this.appGroupName = appGroupName;
        }
    }

    @Override
    public void setIpAddr(String ipAddr) {
        if (StringUtils.isNotEmpty((CharSequence)ipAddr)) {
            this.ipAddr = ipAddr;
        }
    }

    @Override
    public void setVipAddress(String vipAddress) {
        if (StringUtils.isNotEmpty((CharSequence)vipAddress)) {
            this.vipAddress = vipAddress;
        }
    }

    @Override
    public void setSecureVipAddress(String secureVipAddress) {
        if (StringUtils.isNotEmpty((CharSequence)secureVipAddress)) {
            this.secureVipAddress = secureVipAddress;
        }
    }

    public void setMetadata(Map<String, String> metadata) {
        if (metadata != null) {
            this.metadata = metadata;
        }
    }

    private String portString() {
        return this.port > 0 ? ":" + this.port : "";
    }

    private String securePortString() {
        return this.securePort > 0 ? ":" + this.securePort : "";
    }

    private static String lookupIp(String host) {
        try {
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unable to lookup host IP address: " + host, e);
        }
    }

    public static enum Status {
        UP,
        DOWN,
        STARTING,
        OUT_OF_SERVICE,
        UNKNOWN;

    }

    static class PortWrapper {
        private final boolean enabled;
        private final int port;

        @JsonCreator
        public PortWrapper(@JsonProperty(value="@enabled") boolean enabled, @JsonProperty(value="$") int port) {
            this.enabled = enabled;
            this.port = port;
        }

        @JsonProperty(value="@enabled")
        public boolean isEnabled() {
            return this.enabled;
        }

        @JsonProperty(value="$")
        public int getPort() {
            return this.port;
        }
    }
}

