/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.spring.config;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.discovery.config.ConfigDiscoveryConfiguration;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Inject;
import java.util.Optional;

@ConfigurationProperties(value="spring.cloud.config")
@BootstrapContextCompatible
@Requires(property="spring.cloud.config.enabled", value="true", defaultValue="false")
public class SpringCloudClientConfiguration
extends HttpClientConfiguration {
    public static final String PREFIX = "spring.cloud.config";
    public static final boolean DEFAULT_FAIL_FAST = false;
    private static final String DEFAULT_URI = "http://localhost:8888";
    public static final String SPRING_CLOUD_CONFIG_ENDPOINT = "${spring.cloud.config.uri:`http://localhost:8888`}";
    private String uri = "http://localhost:8888";
    private String label;
    private boolean failFast = false;
    private String name;
    private String username;
    private String password;
    private final SpringCloudConnectionPoolConfiguration springCloudConnectionPoolConfiguration;
    private final SpringConfigDiscoveryConfiguration springConfigDiscoveryConfiguration = new SpringConfigDiscoveryConfiguration();

    public SpringCloudClientConfiguration() {
        this.springCloudConnectionPoolConfiguration = new SpringCloudConnectionPoolConfiguration();
    }

    @Inject
    public SpringCloudClientConfiguration(SpringCloudConnectionPoolConfiguration springCloudConnectionPoolConfiguration, ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
        this.springCloudConnectionPoolConfiguration = springCloudConnectionPoolConfiguration;
    }

    @NonNull
    public HttpClientConfiguration.ConnectionPoolConfiguration getConnectionPoolConfiguration() {
        return this.springCloudConnectionPoolConfiguration;
    }

    @NonNull
    public SpringConfigDiscoveryConfiguration getConfiguration() {
        return this.springConfigDiscoveryConfiguration;
    }

    @NonNull
    public Optional<String> getUri() {
        return this.uri != null ? Optional.of(this.uri) : Optional.empty();
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getLabel() {
        return this.label;
    }

    public Optional<String> getName() {
        return this.name != null ? Optional.of(this.name) : Optional.empty();
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    @ConfigurationProperties(value="config")
    @BootstrapContextCompatible
    public static class SpringConfigDiscoveryConfiguration
    extends ConfigDiscoveryConfiguration {
        public static final String PREFIX = "spring.cloud.config.config";
    }

    @ConfigurationProperties(value="pool")
    @BootstrapContextCompatible
    public static class SpringCloudConnectionPoolConfiguration
    extends HttpClientConfiguration.ConnectionPoolConfiguration {
    }
}

