/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.client;

import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.core.order.Ordered;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.ServiceInstanceList;
import io.micronaut.discovery.client.DiscoveryClientConfiguration;
import io.micronaut.discovery.client.EndpointUtil;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class DiscoveryServerInstanceList
implements ServiceInstanceList,
ApplicationEventListener<ServerStartupEvent>,
Ordered {
    private final DiscoveryClientConfiguration configuration;
    private final ApplicationConfiguration.InstanceConfiguration instanceConfiguration;
    private EmbeddedServer serverInstance;

    public DiscoveryServerInstanceList(DiscoveryClientConfiguration configuration, ApplicationConfiguration.InstanceConfiguration instanceConfiguration) {
        this.configuration = configuration;
        this.instanceConfiguration = instanceConfiguration;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public List<ServiceInstance> getInstances() {
        if (this.configuration.isShouldUseDns() && this.serverInstance != null) {
            List<String> serviceUrlsFromDNS = EndpointUtil.getServiceUrlsFromDNS(this.serverInstance, this.instanceConfiguration, this.configuration);
            ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>();
            for (String serviceUrlsFromDN : serviceUrlsFromDNS) {
                serviceInstances.add(ServiceInstance.builder((String)this.getID(), (URI)URI.create(serviceUrlsFromDN)).build());
            }
            return serviceInstances;
        }
        List<ServiceInstance> allZones = this.configuration.getAllZones();
        if (!allZones.isEmpty()) {
            return allZones;
        }
        String spec = (this.configuration.isSecure() ? "https" : "http") + "://" + this.configuration.getHost() + ":" + this.configuration.getPort();
        return Collections.singletonList(ServiceInstance.builder((String)this.getID(), (URI)URI.create(spec)).build());
    }

    public void onApplicationEvent(ServerStartupEvent event) {
        this.serverInstance = event.getSource();
    }
}

