/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.client;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

final class DnsResolver {
    private static final String DNS_PROVIDER_URL = "dns:";
    private static final String DNS_NAMING_FACTORY = "com.sun.jndi.dns.DnsContextFactory";
    private static final String JAVA_NAMING_FACTORY_INITIAL = "java.naming.factory.initial";
    private static final String JAVA_NAMING_PROVIDER_URL = "java.naming.provider.url";
    private static final String TXT_RECORD_TYPE = "TXT";
    private static final DirContext DIR_CONTEXT = DnsResolver.getDirContext();

    private DnsResolver() {
    }

    static Set<String> getCNamesFromTxtRecord(String discoveryDnsName) throws NamingException {
        Attributes attrs = DIR_CONTEXT.getAttributes(discoveryDnsName, new String[]{TXT_RECORD_TYPE});
        Attribute attr = attrs.get(TXT_RECORD_TYPE);
        String txtRecord = null;
        if (attr != null && (txtRecord = attr.get().toString()).startsWith("\"") && txtRecord.endsWith("\"")) {
            txtRecord = txtRecord.substring(1, txtRecord.length() - 1);
        }
        TreeSet<String> cnamesSet = new TreeSet<String>();
        if (txtRecord == null || txtRecord.trim().isEmpty()) {
            return cnamesSet;
        }
        String[] cnames = txtRecord.split(" ");
        Collections.addAll(cnamesSet, cnames);
        return cnamesSet;
    }

    private static DirContext getDirContext() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put(JAVA_NAMING_FACTORY_INITIAL, DNS_NAMING_FACTORY);
        env.put(JAVA_NAMING_PROVIDER_URL, DNS_PROVIDER_URL);
        try {
            return new InitialDirContext(env);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot get dir context for some reason", e);
        }
    }
}

