/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.client.v1;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.Toggleable;
import io.micronaut.discovery.consul.ConsulConfiguration;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.ClientFilter;
import io.micronaut.http.annotation.RequestFilter;
import java.util.Optional;

@ClientFilter(patterns={"/v1/**"}, serviceId={"consul"})
@Requires(beans={ConsulConfiguration.class})
@BootstrapContextCompatible
public final class ConsulAslTokenClientFilter
implements Toggleable {
    public static final String HEADER_CONSUL_TOKEN = "X-Consul-Token";
    private final ConsulConfiguration configuration;

    public ConsulAslTokenClientFilter(ConsulConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isEnabled() {
        return this.configuration.getAslToken().isPresent();
    }

    @RequestFilter
    void filterRequest(MutableHttpRequest<?> request) {
        Optional<String> aslToken = this.configuration.getAslToken();
        aslToken.ifPresent(token -> request.header((CharSequence)HEADER_CONSUL_TOKEN, (CharSequence)token));
    }
}

