/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.watch;

import io.micronaut.context.env.PropertySourceReader;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.consul.client.v1.KeyValue;
import io.micronaut.discovery.consul.client.v1.blockingqueries.BlockedQueriesConsulClient;
import io.micronaut.discovery.consul.client.v1.blockingqueries.BlockingQueriesConfiguration;
import io.micronaut.discovery.consul.watch.AbstractWatcher;
import io.micronaut.discovery.consul.watch.KvUtils;
import io.micronaut.discovery.consul.watch.PropertiesChangeHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Internal
final class ConfigurationsWatcher
extends AbstractWatcher<KeyValue> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationsWatcher.class);
    private final PropertySourceReader propertySourceReader;

    ConfigurationsWatcher(List<String> kvPaths, BlockedQueriesConsulClient consulClient, BlockingQueriesConfiguration blockingQueriesConfiguration, PropertiesChangeHandler propertiesChangeHandler, PropertySourceReader propertySourceReader) {
        super(kvPaths, consulClient, blockingQueriesConfiguration, propertiesChangeHandler);
        this.propertySourceReader = propertySourceReader;
    }

    @Override
    protected Mono<KeyValue> watchValue(String kvPath) {
        Integer modifiedIndex = Optional.ofNullable((KeyValue)this.kvHolder.get(kvPath)).map(KeyValue::getModifyIndex).orElse(NO_INDEX);
        LOG.debug("Watching kvPath={} with index={}", (Object)kvPath, (Object)modifiedIndex);
        return this.consulClient.watchValues(kvPath, false, modifiedIndex).flatMapMany(Flux::fromIterable).filter(kv -> kvPath.equals(kv.getKey())).singleOrEmpty();
    }

    @Override
    protected boolean areEqual(KeyValue previous, KeyValue next) {
        return KvUtils.areEqual(previous, next);
    }

    @Override
    protected Map<String, Object> readValue(KeyValue keyValue) {
        if (keyValue == null || StringUtils.isEmpty((CharSequence)keyValue.getValue())) {
            return Collections.emptyMap();
        }
        return this.propertySourceReader.read(keyValue.getKey(), this.decodeValue(keyValue));
    }
}

