/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.watch;

import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Singleton
public class PropertiesChangeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesChangeHandler.class);
    private final Environment environment;
    private final ApplicationEventPublisher<RefreshEvent> eventPublisher;
    private final Map<String, String> propertySourceNames = new ConcurrentHashMap<String, String>();

    PropertiesChangeHandler(Environment environment, ApplicationEventPublisher<RefreshEvent> eventPublisher) {
        this.environment = environment;
        this.eventPublisher = eventPublisher;
    }

    void handleChanges(String kvPath, Map<String, Object> previous, Map<String, Object> next) {
        try {
            LinkedHashMap<String, Object> copyNext = new LinkedHashMap<String, Object>(next);
            HashMap<String, Object> differences = new HashMap<String, Object>();
            previous.forEach((key, previousValue) -> {
                if (next.containsKey(key)) {
                    Object nextValue = copyNext.remove(key);
                    if (!Objects.deepEquals(previousValue, nextValue)) {
                        differences.put((String)key, previousValue);
                    }
                } else {
                    differences.put((String)key, previousValue);
                }
            });
            copyNext.keySet().forEach(key -> differences.put((String)key, null));
            if (differences.isEmpty()) {
                LOG.debug("No properties differences found for update of kvPath={}", (Object)kvPath);
            } else {
                this.updatePropertySources(kvPath, next);
                this.publishDifferences(differences);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to apply configuration changes", (Throwable)e);
        }
    }

    private void updatePropertySources(String kvPath, Map<String, Object> newValues) {
        String propertySourceName = this.toPropertySourceName(kvPath);
        LOG.debug("Updating context with new configurations for {}", (Object)propertySourceName);
        ArrayList<PropertySource> updatedPropertySources = new ArrayList<PropertySource>();
        for (PropertySource propertySource : this.environment.getPropertySources()) {
            if (propertySource.getName().equals(propertySourceName)) {
                updatedPropertySources.add(PropertySource.of((String)propertySourceName, newValues, (int)propertySource.getOrder()));
                continue;
            }
            updatedPropertySources.add(propertySource);
        }
        updatedPropertySources.stream().sorted(Comparator.comparing(Ordered::getOrder)).forEach(arg_0 -> ((Environment)this.environment).addPropertySource(arg_0));
    }

    private String toPropertySourceName(String kvPath) {
        return this.propertySourceNames.computeIfAbsent(kvPath, PropertiesChangeHandler::resolvePropertySourceName);
    }

    private static String resolvePropertySourceName(String kvPath) {
        String propertySourceName = (String)CollectionUtils.last(List.of(kvPath.split("/")));
        String[] tokens = propertySourceName.split(",");
        if (tokens.length == 1) {
            return "consul-" + propertySourceName;
        }
        String name = tokens[0];
        String envName = tokens[1];
        return "consul-" + name + "[" + envName + "]";
    }

    private void publishDifferences(Map<String, Object> changes) {
        if (changes.isEmpty()) {
            return;
        }
        LOG.debug("Configuration has been updated, publishing RefreshEvent.");
        this.eventPublisher.publishEvent((Object)new RefreshEvent(changes));
    }
}

