/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.vault.config;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.config.ConfigurationClient;
import io.micronaut.discovery.vault.config.VaultClientConfiguration;
import io.micronaut.discovery.vault.config.VaultConfigHttpClient;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Singleton
@BootstrapContextCompatible
@Requires(beans={VaultClientConfiguration.class})
public class VaultConfigurationClient
implements ConfigurationClient {
    private static final Logger LOG = LoggerFactory.getLogger(VaultConfigurationClient.class);
    private static final String DEFAULT_APPLICATION = "application";
    private final VaultConfigHttpClient<?> configHttpClient;
    private final VaultClientConfiguration vaultClientConfiguration;
    private final ApplicationConfiguration applicationConfiguration;
    private final ExecutorService executorService;

    public VaultConfigurationClient(VaultConfigHttpClient<?> configHttpClient, VaultClientConfiguration vaultClientConfiguration, ApplicationConfiguration applicationConfiguration, @Named(value="io") @Nullable ExecutorService executorService) {
        this.configHttpClient = configHttpClient;
        this.vaultClientConfiguration = vaultClientConfiguration;
        this.applicationConfiguration = applicationConfiguration;
        this.executorService = executorService;
    }

    public Publisher<PropertySource> getPropertySources(Environment environment) {
        if (!this.vaultClientConfiguration.getDiscoveryConfiguration().isEnabled()) {
            return Flux.empty();
        }
        String applicationName = this.applicationConfiguration.getName().orElse(null);
        Set activeNames = environment.getActiveNames();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Vault server endpoint: {}, secret engine version: {}, secret-engine-name: {}, vault keys path prefix: {}", new Object[]{this.vaultClientConfiguration.getUri(), this.vaultClientConfiguration.getKvVersion(), this.vaultClientConfiguration.getSecretEngineName(), this.vaultClientConfiguration.getPathPrefix()});
            LOG.debug("Application name: {}, application profiles: {}", (Object)applicationName, (Object)activeNames);
        }
        ArrayList propertySources = new ArrayList();
        String token = this.vaultClientConfiguration.getToken();
        String engine = this.vaultClientConfiguration.getSecretEngineName();
        String pathPrefix = this.normalizePathPrefix(this.vaultClientConfiguration.getPathPrefix());
        Scheduler scheduler = this.executorService != null ? Schedulers.fromExecutor((Executor)this.executorService) : null;
        this.buildVaultKeys(pathPrefix, applicationName, activeNames).forEach((key, value) -> {
            Flux propertySourceFlowable = Flux.from(this.configHttpClient.readConfigurationValues(token, engine, (String)value)).filter(data -> !data.getSecrets().isEmpty()).map(data -> PropertySource.of((String)value, data.getSecrets(), (int)key)).onErrorResume(t -> {
                if (t instanceof HttpClientResponseException) {
                    HttpClientResponseException hcre = (HttpClientResponseException)t;
                    if (hcre.getStatus() == HttpStatus.NOT_FOUND && this.vaultClientConfiguration.isFailFast()) {
                        return Flux.error((Throwable)new ConfigurationException("Could not locate PropertySource and the fail fast property is set", t));
                    }
                    return Flux.empty();
                }
                return Flux.error((Throwable)new ConfigurationException("Error reading distributed configuration from Vault: " + t.getMessage(), t));
            });
            if (scheduler != null) {
                propertySourceFlowable = propertySourceFlowable.subscribeOn(scheduler);
            }
            propertySources.add(propertySourceFlowable);
        });
        return Flux.merge(propertySources);
    }

    protected Map<Integer, String> buildVaultKeys(@Nullable String pathPrefix, @Nullable String applicationName, Set<String> environmentNames) {
        HashMap<Integer, String> vaultKeys = new HashMap<Integer, String>();
        int baseOrder = -100;
        int envOrder = baseOrder + 50;
        vaultKeys.put(++baseOrder, DEFAULT_APPLICATION);
        if (applicationName != null) {
            vaultKeys.put(++baseOrder, applicationName);
        }
        for (String activeName : environmentNames) {
            vaultKeys.put(++envOrder, "application/" + activeName);
            if (applicationName == null) continue;
            vaultKeys.put(++envOrder, applicationName + "/" + activeName);
        }
        return StringUtils.isNotEmpty((CharSequence)pathPrefix) ? this.prefixVaultKeys(pathPrefix, vaultKeys) : vaultKeys;
    }

    private Map<Integer, String> prefixVaultKeys(String prefix, Map<Integer, String> vaultKeys) {
        return vaultKeys.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> StringUtils.prependUri((String)prefix, (String)((String)entry.getValue()))));
    }

    private String normalizePathPrefix(String prefix) {
        if (prefix.length() > 0 && prefix.charAt(0) == '/') {
            return prefix.substring(1);
        }
        return prefix;
    }

    @NonNull
    public String getDescription() {
        return this.configHttpClient.getDescription();
    }
}

