/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.client.v1;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.consul.ConsulConfiguration;
import io.micronaut.discovery.consul.ConsulServiceInstance;
import io.micronaut.discovery.consul.client.v1.ConsulClient;
import io.micronaut.discovery.consul.client.v1.ConsulHealthEntry;
import io.micronaut.discovery.consul.client.v1.HTTPCheck;
import io.micronaut.discovery.consul.client.v1.TTLCheck;
import io.micronaut.http.client.annotation.Client;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Client(id="consul", path="/v1", configuration=ConsulConfiguration.class)
@Requires(beans={ConsulConfiguration.class})
@TypeHint(value={TTLCheck.class, HTTPCheck.class})
@BootstrapContextCompatible
public abstract class AbstractConsulClient
implements ConsulClient {
    static final String CONSUL_REGISTRATION_RETRY_COUNT = "${consul.client.registration.retry-count:3}";
    static final String CONSUL_REGISTRATION_RETRY_DELAY = "${consul.client.registration.retry-delay:3s}";
    static final String EXPR_CONSUL_CONFIG_RETRY_COUNT = "${consul.client.config.retry-count:3}";
    static final String EXPR_CONSUL_CONFIG_RETRY_DELAY = "${consul.client.config.retry-delay:1s}";
    private ConsulConfiguration consulConfiguration = new ConsulConfiguration();

    @Inject
    public void setConsulConfiguration(ConsulConfiguration consulConfiguration) {
        if (consulConfiguration != null) {
            this.consulConfiguration = consulConfiguration;
        }
    }

    public String getDescription() {
        return "consul";
    }

    @Override
    public Publisher<List<String>> getServiceIds() {
        if (!this.consulConfiguration.getDiscovery().isEnabled()) {
            return Publishers.just(Collections.emptyList());
        }
        return ConsulClient.super.getServiceIds();
    }

    public Publisher<List<ServiceInstance>> getInstances(String serviceId) {
        if (!this.consulConfiguration.getDiscovery().isEnabled()) {
            return Publishers.just(Collections.emptyList());
        }
        if ("consul".equals(serviceId = NameUtils.hyphenate((String)serviceId))) {
            return Publishers.just(Collections.singletonList(ServiceInstance.of((String)"consul", (String)this.consulConfiguration.getHost(), (int)this.consulConfiguration.getPort())));
        }
        ConsulConfiguration.ConsulDiscoveryConfiguration discovery = this.consulConfiguration.getDiscovery();
        boolean passing = discovery.isPassing();
        String datacenter = discovery.getDatacenters().get(serviceId);
        String tag = discovery.getTags().get(serviceId);
        Optional<String> scheme = Optional.ofNullable(discovery.getSchemes().get(serviceId));
        Publisher<List<ConsulHealthEntry>> healthyServicesPublisher = this.findHealthyServices(serviceId, passing, tag, datacenter);
        return Publishers.map(healthyServicesPublisher, healthEntries -> {
            ArrayList<ConsulServiceInstance> serviceInstances = new ArrayList<ConsulServiceInstance>();
            for (ConsulHealthEntry healthEntry : healthEntries) {
                serviceInstances.add(new ConsulServiceInstance(healthEntry, scheme.orElse("http")));
            }
            return serviceInstances;
        });
    }
}

