/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.client.v1.blockingqueries;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.discovery.consul.ConsulConfiguration;
import io.micronaut.discovery.consul.condition.RequiresConsul;
import io.micronaut.http.client.HttpClientConfiguration;
import java.time.Duration;
import java.util.Optional;

@RequiresConsul
@ConfigurationProperties(value="consul.client.blocking-queries")
public class BlockingQueriesConfiguration
extends HttpClientConfiguration {
    public static final String PREFIX = "consul.client.blocking-queries";
    public static final String DEFAULT_MAX_WAIT_DURATION_MINUTES = "10m";
    public static final long DEFAULT_DELAY_DURATION_MILLISECONDS = 50L;
    private String maxWaitDuration = "10m";
    private Duration delayDuration = Duration.ofMillis(50L);
    private Duration readTimeout = null;
    private final ConsulConfiguration consulConfiguration;
    private final ConversionService conversionService;

    public BlockingQueriesConfiguration(ConsulConfiguration consulConfiguration, ConversionService conversionService) {
        super((HttpClientConfiguration)consulConfiguration);
        this.consulConfiguration = consulConfiguration;
        this.conversionService = conversionService;
    }

    public HttpClientConfiguration.ConnectionPoolConfiguration getConnectionPoolConfiguration() {
        return this.consulConfiguration.getConnectionPoolConfiguration();
    }

    public Optional<Duration> getReadTimeout() {
        if (this.readTimeout == null) {
            this.readTimeout = this.calculateReadTimeout();
        }
        return Optional.of(this.readTimeout);
    }

    private Duration calculateReadTimeout() {
        String waitValue = Optional.ofNullable(this.getMaxWaitDuration()).orElse(DEFAULT_MAX_WAIT_DURATION_MINUTES);
        Duration duration = (Duration)this.conversionService.convertRequired((Object)waitValue, Duration.class);
        return duration.plusMillis(duration.toMillis() / 16L);
    }

    @Nullable
    public String getMaxWaitDuration() {
        return this.maxWaitDuration;
    }

    public void setMaxWaitDuration(@Nullable String maxWaitDuration) {
        this.maxWaitDuration = maxWaitDuration;
        this.readTimeout = this.calculateReadTimeout();
    }

    @NonNull
    public Duration getDelayDuration() {
        return this.delayDuration;
    }

    public void setDelayDuration(Duration delayDuration) {
        this.delayDuration = delayDuration == null ? Duration.ofMillis(50L) : delayDuration;
    }
}

