/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.watch;

import io.micronaut.core.annotation.Internal;
import io.micronaut.discovery.consul.client.v1.KeyValue;
import java.util.Comparator;
import java.util.List;

@Internal
final class KvUtils {
    private KvUtils() {
    }

    static boolean areEqual(KeyValue left, KeyValue right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.getKey().equals(right.getKey()) && left.getValue().equals(right.getValue());
    }

    static boolean areEqual(List<KeyValue> left, List<KeyValue> right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.size() != right.size()) {
            return false;
        }
        left.sort(Comparator.comparing(KeyValue::getKey));
        right.sort(Comparator.comparing(KeyValue::getKey));
        for (int i = 0; i < left.size(); ++i) {
            KeyValue leftKV = left.get(i);
            KeyValue rightKV = right.get(i);
            if (KvUtils.areEqual(rightKV, leftKV)) continue;
            return false;
        }
        return true;
    }
}

