/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.watch;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.consul.client.v1.KeyValue;
import io.micronaut.discovery.consul.client.v1.blockingqueries.BlockedQueriesConsulClient;
import io.micronaut.discovery.consul.client.v1.blockingqueries.BlockingQueriesConfiguration;
import io.micronaut.discovery.consul.watch.AbstractWatcher;
import io.micronaut.discovery.consul.watch.KvUtils;
import io.micronaut.discovery.consul.watch.PropertiesChangeHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Internal
final class NativeWatcher
extends AbstractWatcher<List<KeyValue>> {
    private static final Logger LOG = LoggerFactory.getLogger(NativeWatcher.class);
    private final Map<String, String> keysMap = new HashMap<String, String>();

    NativeWatcher(List<String> kvPaths, BlockedQueriesConsulClient consulClient, BlockingQueriesConfiguration blockingQueriesConfiguration, PropertiesChangeHandler propertiesChangeHandler) {
        super(kvPaths, consulClient, blockingQueriesConfiguration, propertiesChangeHandler);
    }

    @Override
    protected Mono<List<KeyValue>> watchValue(String kvPath) {
        Integer modifiedIndex = Optional.ofNullable((List)this.kvHolder.get(kvPath)).stream().flatMap(Collection::stream).map(KeyValue::getModifyIndex).max(Integer::compareTo).orElse(NO_INDEX);
        LOG.debug("Watching kvPath={} with index={}", (Object)kvPath, (Object)modifiedIndex);
        return this.consulClient.watchValues(kvPath, true, modifiedIndex);
    }

    @Override
    protected boolean areEqual(List<KeyValue> previous, List<KeyValue> next) {
        return KvUtils.areEqual(previous, next);
    }

    @Override
    protected Map<String, Object> readValue(List<KeyValue> keyValues) {
        if (keyValues == null) {
            return Collections.emptyMap();
        }
        return keyValues.stream().filter(Objects::nonNull).filter(kv -> StringUtils.isNotEmpty((CharSequence)kv.getValue())).collect(Collectors.toMap(this::pathToPropertyKey, keyValue -> new String(this.decodeValue((KeyValue)keyValue))));
    }

    private String pathToPropertyKey(KeyValue kv) {
        return this.keysMap.computeIfAbsent(kv.getKey(), key -> (String)CollectionUtils.last(List.of(key.split("/"))));
    }
}

