/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.watch;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertiesPropertySourceLoader;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.context.env.PropertySourceReader;
import io.micronaut.context.env.yaml.YamlPropertySourceLoader;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.discovery.config.ConfigDiscoveryConfiguration;
import io.micronaut.discovery.consul.ConsulConfiguration;
import io.micronaut.discovery.consul.client.v1.blockingqueries.BlockedQueriesConsulClient;
import io.micronaut.discovery.consul.client.v1.blockingqueries.BlockingQueriesConfiguration;
import io.micronaut.discovery.consul.watch.ConfigurationsWatcher;
import io.micronaut.discovery.consul.watch.NativeWatcher;
import io.micronaut.discovery.consul.watch.PropertiesChangeHandler;
import io.micronaut.discovery.consul.watch.Watcher;
import io.micronaut.jackson.core.env.JsonPropertySourceLoader;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@Factory
@Internal
final class WatchFactory {
    private static final String CONSUL_PATH_SEPARATOR = "/";
    private final Environment environment;
    private final BlockedQueriesConsulClient consulClient;
    private final BlockingQueriesConfiguration blockingQueriesConfiguration;
    private final PropertiesChangeHandler propertiesChangeHandler;

    WatchFactory(Environment environment, BlockedQueriesConsulClient consulClient, BlockingQueriesConfiguration blockingQueriesConfiguration, PropertiesChangeHandler propertiesChangeHandler) {
        this.environment = environment;
        this.consulClient = consulClient;
        this.blockingQueriesConfiguration = blockingQueriesConfiguration;
        this.propertiesChangeHandler = propertiesChangeHandler;
    }

    @Singleton
    Watcher createWatcher(ConsulConfiguration consulConfiguration) {
        List<String> kvPaths = this.computeKvPaths(consulConfiguration);
        ConfigDiscoveryConfiguration.Format format = consulConfiguration.getConfiguration().getFormat();
        return switch (format) {
            case ConfigDiscoveryConfiguration.Format.NATIVE -> this.watchNative(kvPaths);
            case ConfigDiscoveryConfiguration.Format.JSON -> this.watchConfigurations(kvPaths, (PropertySourceLoader)new JsonPropertySourceLoader());
            case ConfigDiscoveryConfiguration.Format.YAML -> this.watchConfigurations(kvPaths, (PropertySourceLoader)new YamlPropertySourceLoader());
            case ConfigDiscoveryConfiguration.Format.PROPERTIES -> this.watchConfigurations(kvPaths, (PropertySourceLoader)new PropertiesPropertySourceLoader());
            default -> throw new ConfigurationException("Unhandled configuration format: " + format);
        };
    }

    List<String> computeKvPaths(ConsulConfiguration consulConfiguration) {
        String applicationName = consulConfiguration.getServiceId().orElseThrow();
        String configurationPath = WatchFactory.getConfigurationPath(consulConfiguration);
        ArrayList<String> kvPaths = new ArrayList<String>();
        String commonConfigPath = configurationPath + "application";
        kvPaths.add(commonConfigPath);
        String applicationSpecificPath = configurationPath + applicationName;
        kvPaths.add(applicationSpecificPath);
        for (String activeName : this.environment.getActiveNames()) {
            kvPaths.add(WatchFactory.toProfiledPath(commonConfigPath, activeName));
            kvPaths.add(WatchFactory.toProfiledPath(applicationSpecificPath, activeName));
        }
        return kvPaths;
    }

    private static String getConfigurationPath(ConsulConfiguration consulConfiguration) {
        return consulConfiguration.getConfiguration().getPath().map(path -> {
            if (!((String)path).endsWith(CONSUL_PATH_SEPARATOR)) {
                path = (String)path + CONSUL_PATH_SEPARATOR;
            }
            return path;
        }).orElse("config/");
    }

    private static String toProfiledPath(String resource, String activeName) {
        return resource + "," + activeName;
    }

    private Watcher watchNative(List<String> keyPaths) {
        List<String> kvPaths = keyPaths.stream().map(path -> path + CONSUL_PATH_SEPARATOR).toList();
        return new NativeWatcher(kvPaths, this.consulClient, this.blockingQueriesConfiguration, this.propertiesChangeHandler);
    }

    private Watcher watchConfigurations(List<String> kvPaths, PropertySourceLoader propertySourceLoader) {
        return new ConfigurationsWatcher(kvPaths, this.consulClient, this.blockingQueriesConfiguration, this.propertiesChangeHandler, (PropertySourceReader)propertySourceLoader);
    }
}

