/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.eureka.registration;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.ServiceInstanceIdGenerator;
import io.micronaut.discovery.client.registration.DiscoveryServiceAutoRegistration;
import io.micronaut.discovery.eureka.EurekaConfiguration;
import io.micronaut.discovery.eureka.client.v2.EurekaClient;
import io.micronaut.discovery.eureka.client.v2.InstanceInfo;
import io.micronaut.health.HealthStatus;
import io.micronaut.health.HeartbeatConfiguration;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.runtime.server.EmbeddedServer;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Mono;

@Singleton
@Requirements(value={@Requires(beans={EurekaClient.class, EmbeddedServer.class}), @Requires(property="micronaut.application.name")})
public class EurekaAutoRegistration
extends DiscoveryServiceAutoRegistration {
    private static final String EUREKA_SERVICE_NAME = "Eureka";
    private final Environment environment;
    private final EurekaClient eurekaClient;
    private final EurekaConfiguration eurekaConfiguration;
    private final HeartbeatConfiguration heartbeatConfiguration;
    private final ServiceInstanceIdGenerator idGenerator;
    private final AtomicReference<HealthStatus> lastStatus = new AtomicReference();

    protected EurekaAutoRegistration(Environment environment, EurekaClient eurekaClient, EurekaConfiguration eurekaConfiguration, HeartbeatConfiguration heartbeatConfiguration, ServiceInstanceIdGenerator idGenerator) {
        super(eurekaConfiguration.getRegistration());
        this.environment = environment;
        this.eurekaClient = eurekaClient;
        this.eurekaConfiguration = eurekaConfiguration;
        this.heartbeatConfiguration = heartbeatConfiguration;
        this.idGenerator = idGenerator;
    }

    protected void pulsate(ServiceInstance instance, HealthStatus status) {
        EurekaConfiguration.EurekaRegistrationConfiguration registration = this.eurekaConfiguration.getRegistration();
        if (this.heartbeatConfiguration.isEnabled() && registration != null && this.registered.get()) {
            HealthStatus lastStatus;
            InstanceInfo instanceInfo = registration.getInstanceInfo();
            if (status.equals((Object)HealthStatus.UP)) {
                Mono heartbeatPublisher = Mono.from(this.eurekaClient.heartbeat(instanceInfo.getApp(), instanceInfo.getId()));
                heartbeatPublisher.subscribe(httpStatus -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Successfully reported passing state to Eureka");
                    }
                }, throwable -> {
                    HttpClientResponseException hcre;
                    HttpStatus httpStatus;
                    if (throwable instanceof HttpClientResponseException && (httpStatus = (hcre = (HttpClientResponseException)throwable).getStatus()) == HttpStatus.NOT_FOUND) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Instance [{}] no longer registered with Eureka. Attempting re-registration.", (Object)instance.getId());
                        }
                        this.register(instance);
                        return;
                    }
                    String errorMessage = this.getErrorMessage((Throwable)throwable, "Error reporting passing state to Eureka: ");
                    if (LOG.isErrorEnabled()) {
                        LOG.error(errorMessage, throwable);
                    }
                });
            }
            if ((lastStatus = this.lastStatus.getAndSet(status)) == null || !lastStatus.equals((Object)status)) {
                final InstanceInfo.Status s = this.translateState(status);
                this.eurekaClient.updateStatus(instanceInfo.getApp(), instanceInfo.getId(), s).subscribe((Subscriber)new Subscriber<HttpStatus>(){

                    public void onSubscribe(Subscription s2) {
                        s2.request(1L);
                    }

                    public void onNext(HttpStatus httpStatus) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Successfully reported status {} to Eureka", (Object)s);
                        }
                    }

                    public void onError(Throwable t) {
                        String errorMessage = EurekaAutoRegistration.this.getErrorMessage(t, "Error reporting state to Eureka: ");
                        if (LOG.isErrorEnabled()) {
                            LOG.error(errorMessage, t);
                        }
                    }

                    public void onComplete() {
                    }
                });
            }
        }
    }

    protected InstanceInfo.Status translateState(HealthStatus status) {
        if (status.equals((Object)HealthStatus.UP)) {
            return InstanceInfo.Status.UP;
        }
        return InstanceInfo.Status.DOWN;
    }

    protected void deregister(ServiceInstance instance) {
        EurekaConfiguration.EurekaRegistrationConfiguration registration = this.eurekaConfiguration.getRegistration();
        if (registration != null) {
            InstanceInfo instanceInfo = registration.getInstanceInfo();
            Publisher<HttpStatus> deregisterPublisher = this.eurekaClient.deregister(instanceInfo.getApp(), instanceInfo.getId());
            this.performDeregistration(EUREKA_SERVICE_NAME, registration, deregisterPublisher, instanceInfo.getApp());
        }
    }

    protected void register(ServiceInstance instance) {
        EurekaConfiguration.EurekaRegistrationConfiguration registration = this.eurekaConfiguration.getRegistration();
        if (registration != null) {
            InstanceInfo instanceInfo = registration.getInstanceInfo();
            if (!registration.isExplicitInstanceId()) {
                instanceInfo.setInstanceId(this.idGenerator.generateId(this.environment, instance));
            }
            ConvertibleValues instanceMetadata = instance.getMetadata();
            Properties properties = instanceMetadata.asProperties();
            Map<String, String> targetMetadata = instanceInfo.getMetadata();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                targetMetadata.put(entry.getKey().toString(), entry.getValue().toString());
            }
            this.customizeInstanceInfo(instanceInfo);
            this.validateApplicationName(instanceInfo.getApp());
            Publisher<HttpStatus> registerPublisher = this.eurekaClient.register(instanceInfo.getApp(), instanceInfo);
            this.performRegistration(EUREKA_SERVICE_NAME, registration, instance, registerPublisher);
        }
    }

    protected void customizeInstanceInfo(InstanceInfo instanceInfo) {
    }
}

