/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.documentation.asciidoc;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.configuration.ConfigurationMetadata;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.configuration.ConfigurationMetadataWriter;
import io.micronaut.inject.configuration.PropertyMetadata;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AsciiDocPropertyReferenceWriter
implements ConfigurationMetadataWriter {
    private static final String AT_PARAM = "@param";
    private static final Pattern PARAM_PATTERN = Pattern.compile("@param\\s*\\w+\\s*(.+)");

    public void write(ConfigurationMetadataBuilder metadataBuilder, ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        Optional file;
        List<PropertyMetadata> props = new ArrayList(metadataBuilder.getProperties()).stream().filter(this.distinctByKey(PropertyMetadata::getPath)).toList();
        List configs = new ArrayList(metadataBuilder.getConfigurations()).stream().sorted(Comparator.comparing(ConfigurationMetadata::getName)).collect(Collectors.toList());
        configs.removeIf(config -> props.stream().noneMatch(pm -> pm.getDeclaringType().equals(config.getType())));
        if (CollectionUtils.isNotEmpty(configs) && (file = classWriterOutputVisitor.visitMetaInfFile("config-properties.adoc", metadataBuilder.getOriginatingElements())).isPresent()) {
            try (BufferedWriter w = new BufferedWriter(((GeneratedFile)file.get()).openWriter());){
                for (ConfigurationMetadata cm : configs) {
                    List<PropertyMetadata> properties = props.stream().filter(pm -> pm.getDeclaringType().equals(cm.getType())).toList();
                    if (properties.isEmpty()) continue;
                    this.write(w, cm, properties);
                }
            }
        }
    }

    private void write(BufferedWriter w, ConfigurationMetadata cm, @NonNull List<PropertyMetadata> value) throws IOException {
        this.writeFragmentLink(w, cm.getType());
        w.newLine();
        w.append(".Configuration Properties for api:").append(cm.getType()).append("[]");
        w.newLine();
        w.append("|===");
        w.newLine();
        w.append("|Property |Type |Description |Default value");
        w.newLine();
        for (PropertyMetadata pm : value) {
            String pmType = pm.getType();
            if (pmType == null || pmType.equals(cm.getType())) continue;
            String path = pm.getPath();
            String description = pm.getDescription();
            if (path.contains("..")) continue;
            if (StringUtils.isEmpty((CharSequence)description)) {
                description = "";
            }
            if ((description = description.trim()).startsWith(AT_PARAM)) {
                Matcher match = PARAM_PATTERN.matcher(description);
                if (match.find()) {
                    description = match.group(1);
                }
            } else if (description.contains(AT_PARAM)) {
                description = description.substring(0, description.indexOf(AT_PARAM)).trim();
            }
            Object type = pm.getType();
            if (((String)type).startsWith("io.micronaut")) {
                type = "api:" + (String)type + "[]";
            }
            w.newLine();
            w.append("| `+").append(path).append("+`");
            w.newLine();
            w.append("|").append((CharSequence)type);
            w.newLine();
            w.append("|").append(description);
            w.newLine();
            w.append("|");
            if (pm.getDefaultValue() != null) {
                w.append(pm.getDefaultValue());
            }
            w.newLine();
            w.newLine();
        }
        w.newLine();
        w.append("|===");
        w.newLine();
        w.append("<<<");
    }

    private void writeFragmentLink(BufferedWriter w, String type) throws IOException {
        w.newLine();
        w.append("++++");
        w.newLine();
        w.append("<a id=\"");
        w.append(type);
        w.append("\" href=\"#");
        w.append(type);
        w.append("\">&#128279;</a>");
        w.newLine();
        w.append("++++");
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, ?> ke) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(ke.apply(t), Boolean.TRUE) == null;
    }
}

