/*
 * Copyright 2017-2020 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.elasticsearch.convert;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClientBuilder;

import jakarta.inject.Singleton;
import java.net.URI;
import java.util.Optional;

/**
 * Converts String to {@link HttpHost}.
 *
 * @author Puneet Behl
 * @since 1.0.0
 */
@Singleton
@Requires(classes = RestClientBuilder.class)
public class StringToHttpHostConverter implements TypeConverter<CharSequence, HttpHost> {

    @Override
    public Optional<HttpHost> convert(CharSequence object, Class<HttpHost> targetType, ConversionContext context) {
        String uriString = object.toString();
        URI uri = URI.create(uriString);
        return Optional.of(new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme()));
    }
}
