/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.elasticsearch.convert;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import jakarta.inject.Singleton;
import java.util.Locale;
import java.util.Optional;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.client.RestClientBuilder;

@Singleton
@Requires(classes={RestClientBuilder.class})
public class StringToNodeSelectorConverter
implements TypeConverter<CharSequence, NodeSelector> {
    public Optional<NodeSelector> convert(CharSequence object, Class<NodeSelector> targetType, ConversionContext context) {
        String nodeSelector;
        switch (nodeSelector = object.toString().toUpperCase(Locale.ENGLISH)) {
            case "SKIP_DEDICATED_MASTERS": {
                return Optional.of(NodeSelector.SKIP_DEDICATED_MASTERS);
            }
            case "ANY": {
                return Optional.of(NodeSelector.ANY);
            }
        }
        return Optional.empty();
    }
}

