/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.elasticsearch.health;

import co.elastic.clients.elasticsearch.ElasticsearchAsyncClient;
import co.elastic.clients.elasticsearch._types.HealthStatus;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import jakarta.inject.Singleton;
import org.reactivestreams.Publisher;

@Requirements(value={@Requires(beans={HealthEndpoint.class}), @Requires(property="endpoints.health.elasticsearch.enabled", notEquals="false"), @Requires(property="endpoints.health.elasticsearch.rest.high.level.enabled", notEquals="true")})
@Singleton
public class ElasticsearchClientHealthIndicator
implements HealthIndicator {
    private static final String NAME = "elasticsearchclient";
    private final ElasticsearchAsyncClient client;

    public ElasticsearchClientHealthIndicator(ElasticsearchAsyncClient client) {
        this.client = client;
    }

    public Publisher<HealthResult> getResult() {
        return subscriber -> {
            HealthResult.Builder resultBuilder = HealthResult.builder((String)NAME);
            this.client.cluster().health().handle((health, exception) -> {
                if (exception != null) {
                    subscriber.onNext((Object)resultBuilder.status(io.micronaut.health.HealthStatus.DOWN).exception(exception).build());
                    subscriber.onComplete();
                } else {
                    io.micronaut.health.HealthStatus status = health.status() == HealthStatus.Red ? io.micronaut.health.HealthStatus.DOWN : io.micronaut.health.HealthStatus.UP;
                    subscriber.onNext((Object)resultBuilder.status(status).details(health).build());
                    subscriber.onComplete();
                }
                return health;
            });
        };
    }
}

