/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.elasticsearch.convert;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import jakarta.inject.Singleton;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(classes={RestClientBuilder.class})
public class StringToInetAddressConverter
implements TypeConverter<CharSequence, InetAddress> {
    private static final Logger LOG = LoggerFactory.getLogger(StringToInetAddressConverter.class);

    public Optional<InetAddress> convert(CharSequence object, Class<InetAddress> targetType, ConversionContext context) {
        String address = object.toString();
        try {
            return Optional.of(InetAddress.getByName(address));
        }
        catch (UnknownHostException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }
}

