/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.elasticsearch.convert;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.client.RestClientBuilder;

@Singleton
@Requires(classes={RestClientBuilder.class})
public class StringToHeaderConverter
implements TypeConverter<CharSequence, Header> {
    public Optional<Header> convert(CharSequence object, Class<Header> targetType, ConversionContext context) {
        String header = object.toString();
        if (header.contains(":")) {
            String[] nameAndValue = header.split(":");
            return Optional.of(new BasicHeader(nameAndValue[0], nameAndValue[1]));
        }
        return Optional.empty();
    }
}

