/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.elasticsearch;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.elasticsearch.DefaultElasticsearchConfiguration;
import io.micronaut.elasticsearch.ElasticsearchSettings;
import jakarta.inject.Inject;
import java.util.Collections;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.client.RestClientBuilder;

@Requires(classes={RestClientBuilder.class})
@ConfigurationProperties(value="elasticsearch")
public class DefaultElasticsearchConfigurationProperties
implements DefaultElasticsearchConfiguration {
    protected HttpAsyncClientBuilder httpAsyncClientBuilder;
    @ConfigurationBuilder(configurationPrefix="request.default")
    protected RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
    private int maxRetryTimeoutMillis;
    private NodeSelector nodeSelector;
    private HttpHost[] httpHosts = Collections.singletonList(ElasticsearchSettings.DEFAULT_HOST).toArray(new HttpHost[1]);
    private Header[] defaultHeaders;

    @Override
    public HttpHost[] getHttpHosts() {
        return this.httpHosts;
    }

    @Override
    public Header[] getDefaultHeaders() {
        return this.defaultHeaders;
    }

    @Override
    public int getMaxRetryTimeoutMillis() {
        return this.maxRetryTimeoutMillis;
    }

    @Override
    public NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public RequestConfig.Builder getRequestConfigBuilder() {
        return this.requestConfigBuilder;
    }

    @Override
    public HttpAsyncClientBuilder getHttpAsyncClientBuilder() {
        return this.httpAsyncClientBuilder;
    }

    public void setHttpHosts(HttpHost[] httpHosts) {
        this.httpHosts = httpHosts;
    }

    public void setDefaultHeaders(Header[] defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public void setMaxRetryTimeoutMillis(int maxRetryTimeoutMillis) {
        this.maxRetryTimeoutMillis = maxRetryTimeoutMillis;
    }

    public void setNodeSelector(NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    @Inject
    public void setHttpAsyncClientBuilder(HttpAsyncClientBuilder httpAsyncClientBuilder) {
        this.httpAsyncClientBuilder = httpAsyncClientBuilder;
    }
}

