/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.elasticsearch.health;

import co.elastic.clients.elasticsearch.ElasticsearchAsyncClient;
import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch.cluster.HealthResponse;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import jakarta.inject.Singleton;
import java.util.Locale;
import org.reactivestreams.Publisher;

@Requirements(value={@Requires(beans={HealthEndpoint.class}), @Requires(property="endpoints.health.elasticsearch.enabled", notEquals="false")})
@Singleton
public class ElasticsearchClientHealthIndicator
implements HealthIndicator {
    private static final String NAME = "elasticsearchclient";
    private final ElasticsearchAsyncClient client;

    public ElasticsearchClientHealthIndicator(ElasticsearchAsyncClient client) {
        this.client = client;
    }

    public Publisher<HealthResult> getResult() {
        return subscriber -> this.client.cluster().health().handle((health, exception) -> {
            HealthResult.Builder resultBuilder = HealthResult.builder((String)NAME);
            if (exception != null) {
                subscriber.onNext((Object)resultBuilder.status(io.micronaut.health.HealthStatus.DOWN).exception(exception).build());
                subscriber.onComplete();
            } else {
                io.micronaut.health.HealthStatus status = health.status() == HealthStatus.Red ? io.micronaut.health.HealthStatus.DOWN : io.micronaut.health.HealthStatus.UP;
                subscriber.onNext((Object)resultBuilder.status(status).details((Object)this.healthResultDetails((HealthResponse)health)).build());
                subscriber.onComplete();
            }
            return health;
        });
    }

    private String healthResultDetails(HealthResponse response) {
        return "{\"cluster_name\":\"" + response.clusterName() + "\",\"status\":\"" + response.status().name().toLowerCase(Locale.ENGLISH) + "\",\"timed_out\":" + response.timedOut() + ",\"number_of_nodes\":" + response.numberOfNodes() + ",\"number_of_data_nodes\":" + response.numberOfDataNodes() + ",\"number_of_pending_tasks\":" + response.numberOfPendingTasks() + ",\"number_of_in_flight_fetch\":" + response.numberOfInFlightFetch() + ",\"task_max_waiting_in_queue\":\"" + response.taskMaxWaitingInQueueMillis() + "\",\"task_max_waiting_in_queue_millis\":" + response.taskMaxWaitingInQueueMillis() + ",\"active_shards_percent_as_number\":\"" + response.activeShardsPercentAsNumber() + "\",\"active_primary_shards\":" + response.activePrimaryShards() + ",\"active_shards\":" + response.activeShards() + ",\"relocating_shards\":" + response.relocatingShards() + ",\"initializing_shards\":" + response.initializingShards() + ",\"unassigned_shards\":" + response.unassignedShards() + ",\"delayed_unassigned_shards\":" + response.delayedUnassignedShards() + "}";
    }
}

