/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email.javamail.composer;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.email.Attachment;
import io.micronaut.email.Body;
import io.micronaut.email.BodyType;
import io.micronaut.email.Contact;
import io.micronaut.email.Email;
import io.micronaut.email.javamail.composer.MessageComposer;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultMessageComposer
implements MessageComposer {
    public static final String TYPE_TEXT_PLAIN_CHARSET_UTF_8 = "text/plain; charset=UTF-8";
    public static final String TYPE_TEXT_HTML_CHARSET_UTF_8 = "text/html; charset=UTF-8";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMessageComposer.class);
    private static final String SUBTYPE_ALTERNATIVE = "alternative";
    private static final EnumMap<BodyType, String> BODY_TYPES;

    @Override
    @NonNull
    public Message compose(@NonNull Email email, @NonNull Session session) throws MessagingException {
        MimeMessage message = new MimeMessage(session);
        message.setSubject(email.getSubject(), "UTF-8");
        message.setFrom((Address)this.contactToAddress(email.getFrom()));
        if (CollectionUtils.isNotEmpty((Collection)email.getTo())) {
            message.setRecipients(Message.RecipientType.TO, this.contactAddresses(email.getTo()));
        }
        if (CollectionUtils.isNotEmpty((Collection)email.getCc())) {
            message.setRecipients(Message.RecipientType.CC, this.contactAddresses(email.getCc()));
        }
        if (CollectionUtils.isNotEmpty((Collection)email.getBcc())) {
            message.setRecipients(Message.RecipientType.BCC, this.contactAddresses(email.getBcc()));
        }
        if (null != email.getReplyTo()) {
            message.setReplyTo(this.contactAddresses(Stream.of(email.getReplyTo()).collect(Collectors.toList())));
        }
        MimeMultipart multipart = new MimeMultipart();
        Body body = email.getBody();
        if (body != null) {
            multipart.addBodyPart((BodyPart)this.bodyPart(body));
        }
        for (MimeBodyPart bodyPart : this.attachmentBodyParts(email)) {
            multipart.addBodyPart((BodyPart)bodyPart);
        }
        message.setContent((Multipart)multipart);
        return message;
    }

    @NonNull
    private MimeBodyPart bodyPart(@NonNull Body body) throws MessagingException {
        MimeBodyPart mbp = new MimeBodyPart();
        MimeMultipart alternativeBody = new MimeMultipart(SUBTYPE_ALTERNATIVE);
        mbp.setContent((Multipart)alternativeBody);
        for (MimeBodyPart part : DefaultMessageComposer.bodyParts(body)) {
            alternativeBody.addBodyPart((BodyPart)part);
        }
        return mbp;
    }

    @NonNull
    private Address[] contactAddresses(@NonNull Collection<Contact> contacts) throws AddressException {
        ArrayList<InternetAddress> addressList = new ArrayList<InternetAddress>();
        for (Contact contact : contacts) {
            addressList.add(this.contactToAddress(contact));
        }
        Address[] array = new Address[addressList.size()];
        addressList.toArray(array);
        return array;
    }

    @NonNull
    private static List<MimeBodyPart> bodyParts(@NonNull Body body) {
        ArrayList<MimeBodyPart> result = new ArrayList<MimeBodyPart>();
        for (Map.Entry<BodyType, String> entry : BODY_TYPES.entrySet()) {
            body.get(entry.getKey()).ifPresent(it -> {
                block2: {
                    try {
                        result.add(DefaultMessageComposer.partForContent((String)entry.getValue(), it));
                    }
                    catch (MessagingException e) {
                        if (!LOG.isErrorEnabled()) break block2;
                        LOG.error("Messaging exception setting {} body part", entry.getValue(), (Object)e);
                    }
                }
            });
        }
        return result;
    }

    @NonNull
    private static MimeBodyPart partForContent(@NonNull String type, @NonNull String content) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setContent((Object)content, type);
        return part;
    }

    @NonNull
    private List<MimeBodyPart> attachmentBodyParts(@NonNull Email email) throws MessagingException {
        if (email.getAttachments() == null) {
            return Collections.emptyList();
        }
        ArrayList<MimeBodyPart> list = new ArrayList<MimeBodyPart>();
        for (Attachment attachment : email.getAttachments()) {
            MimeBodyPart mimeBodyPart = this.attachmentBodyPart(attachment);
            list.add(mimeBodyPart);
        }
        return list;
    }

    private MimeBodyPart attachmentBodyPart(@NonNull Attachment attachment) throws MessagingException {
        MimeBodyPart att = new MimeBodyPart();
        ByteArrayDataSource fds = new ByteArrayDataSource(attachment.getContent(), attachment.getContentType());
        att.setDataHandler(new DataHandler((DataSource)fds));
        String reportName = attachment.getFilename();
        att.setFileName(reportName);
        return att;
    }

    private InternetAddress contactToAddress(Contact contact) throws AddressException {
        if (StringUtils.isNotEmpty((CharSequence)contact.getName())) {
            return InternetAddress.parse((String)(contact.getName() + " <" + contact.getEmail() + ">"))[0];
        }
        return InternetAddress.parse((String)contact.getEmail())[0];
    }

    static {
        EnumMap<BodyType, String> m = new EnumMap<BodyType, String>(BodyType.class);
        m.put(BodyType.TEXT, TYPE_TEXT_PLAIN_CHARSET_UTF_8);
        m.put(BodyType.HTML, TYPE_TEXT_HTML_CHARSET_UTF_8);
        BODY_TYPES = m;
    }
}

