/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email.javamail.sender;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.email.Email;
import io.micronaut.email.EmailComposer;
import io.micronaut.email.EmailException;
import io.micronaut.email.javamail.composer.MessageComposer;
import io.micronaut.email.javamail.sender.SessionProvider;
import jakarta.inject.Singleton;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JavaxEmailComposer
implements EmailComposer<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(JavaxEmailComposer.class);
    private final SessionProvider sessionProvider;
    private final MessageComposer messageComposer;

    public JavaxEmailComposer(SessionProvider sessionProvider, MessageComposer messageComposer) {
        this.sessionProvider = sessionProvider;
        this.messageComposer = messageComposer;
    }

    @NonNull
    public Message compose(@NonNull @NotNull @Valid Email email) throws EmailException {
        Session session = this.sessionProvider.session();
        try {
            return this.messageComposer.compose(email, session);
        }
        catch (MessagingException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("MessagingException composing message", (Throwable)e);
            }
            throw new EmailException((Throwable)e);
        }
    }
}

