/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email.javamail.sender;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.email.AbstractTransactionalEmailSender;
import io.micronaut.email.Email;
import io.micronaut.email.EmailException;
import io.micronaut.email.javamail.composer.MessageComposer;
import io.micronaut.email.javamail.sender.JavaxEmailComposer;
import io.micronaut.email.javamail.sender.SessionProvider;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Transport;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="javaxmail")
@Secondary
@Singleton
@Requires(beans={SessionProvider.class, MessageComposer.class})
public class JavaxEmailSender
extends AbstractTransactionalEmailSender<Message, Void> {
    public static final String NAME = "javaxmail";
    private static final Logger LOG = LoggerFactory.getLogger(JavaxEmailSender.class);
    private final JavaxEmailComposer javaxEmailComposer;

    public JavaxEmailSender(@Named(value="io") ExecutorService executorService, JavaxEmailComposer javaxEmailComposer) {
        super(executorService);
        this.javaxEmailComposer = javaxEmailComposer;
    }

    @NonNull
    public String getName() {
        return NAME;
    }

    @NonNull
    public Void send(@NonNull @NotNull @Valid Email email, @NonNull @NotNull Consumer<Message> emailRequest) throws EmailException {
        Message message = (Message)this.javaxEmailComposer.compose(email, emailRequest);
        try {
            Transport.send((Message)message);
            return null;
        }
        catch (MessagingException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Message could not be sent to some or any of the recipients", (Throwable)e);
            }
            throw new EmailException((Throwable)e);
        }
    }
}

