/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email.javamail.sender;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.email.javamail.sender.JavaMailConfiguration;
import io.micronaut.email.javamail.sender.MailPropertiesProvider;
import jakarta.inject.Singleton;
import java.util.Properties;

@Factory
public class MailPropertiesProviderFactory {
    @Singleton
    @NonNull
    public MailPropertiesProvider buildMailPropertiesProvider(JavaMailConfiguration javaMailConfiguration) {
        if (javaMailConfiguration.getProperties() == null || javaMailConfiguration.getProperties().isEmpty()) {
            throw new DisabledBeanException("JavaMail configuration does not contain any properties");
        }
        return () -> {
            Properties properties = new Properties();
            properties.putAll(javaMailConfiguration.getProperties());
            return properties;
        };
    }
}

