/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email.javamail.sender;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.email.javamail.sender.MailPropertiesProvider;
import io.micronaut.email.javamail.sender.SessionProvider;
import jakarta.inject.Singleton;
import jakarta.mail.Authenticator;
import jakarta.mail.Session;
import java.util.Properties;

@Requires(beans={MailPropertiesProvider.class})
@Secondary
@Singleton
public class DefaultSessionProvider
implements SessionProvider {
    @NonNull
    private final MailPropertiesProvider mailPropertiesProvider;
    @Nullable
    private final Authenticator authenticator;

    public DefaultSessionProvider(MailPropertiesProvider mailPropertiesProvider, @Nullable Authenticator authenticator) {
        this.mailPropertiesProvider = mailPropertiesProvider;
        this.authenticator = authenticator;
    }

    @Override
    @NonNull
    public Session session() {
        Properties props = this.mailPropertiesProvider.mailProperties();
        if (this.authenticator != null && !props.containsKey("mail.smtp.auth")) {
            props.setProperty("mail.smtp.auth", "true");
        }
        return Session.getDefaultInstance((Properties)props, (Authenticator)this.authenticator);
    }
}

