/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email.mailjet;

import com.mailjet.client.MailjetRequest;
import com.mailjet.client.resource.Emailv31;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.email.Attachment;
import io.micronaut.email.Body;
import io.micronaut.email.BodyType;
import io.micronaut.email.Contact;
import io.micronaut.email.Email;
import io.micronaut.email.EmailComposer;
import io.micronaut.email.EmailException;
import jakarta.inject.Singleton;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Base64;
import java.util.Collection;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MailjetEmailComposer
implements EmailComposer<MailjetRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(MailjetEmailComposer.class);

    @NonNull
    public MailjetRequest compose(@NonNull @NotNull @Valid Email email) throws EmailException {
        JSONObject message = new JSONObject();
        message.put(Emailv31.Message.FROM, (Object)MailjetEmailComposer.createJsonObject(email.getFrom()));
        if (CollectionUtils.isNotEmpty((Collection)email.getReplyToCollection())) {
            if (email.getReplyToCollection().size() > 1 && LOG.isWarnEnabled()) {
                LOG.warn("Mailjet does not support multiple 'replyTo' addresses (Email has {} replyTo addresses)", (Object)email.getReplyToCollection().size());
            }
            message.put(Emailv31.Message.REPLYTO, (Object)MailjetEmailComposer.createJsonObject((Contact)CollectionUtils.last((Collection)email.getReplyToCollection())));
        }
        MailjetEmailComposer.to(email).ifPresent(jsonArray -> message.put(Emailv31.Message.TO, jsonArray));
        message.put(Emailv31.Message.SUBJECT, (Object)email.getSubject());
        Body body = email.getBody();
        if (body != null) {
            body.get(BodyType.HTML).ifPresent(html -> message.put(Emailv31.Message.HTMLPART, html));
            body.get(BodyType.TEXT).ifPresent(text -> message.put(Emailv31.Message.TEXTPART, text));
        }
        MailjetEmailComposer.attachmentsAsJsonArray(email, false).ifPresent(arr -> message.put(Emailv31.Message.ATTACHMENTS, arr));
        MailjetEmailComposer.attachmentsAsJsonArray(email, true).ifPresent(arr -> message.put(Emailv31.Message.INLINEDATTACHMENTS, arr));
        JSONArray messages = new JSONArray();
        messages.put((Object)message);
        return new MailjetRequest(Emailv31.resource).property(Emailv31.MESSAGES, (Object)messages);
    }

    @NonNull
    private static Optional<JSONArray> attachmentsAsJsonArray(@NonNull Email email, boolean inline) {
        if (CollectionUtils.isEmpty((Collection)email.getAttachments())) {
            return Optional.empty();
        }
        JSONArray arr = new JSONArray();
        email.getAttachments().stream().filter(att -> "inline".equals(att.getDisposition()) == inline).forEach(att -> arr.put((Object)MailjetEmailComposer.attachmentAsJsonObject(att)));
        return Optional.of(arr);
    }

    @NonNull
    private static JSONObject attachmentAsJsonObject(@NonNull Attachment attachment) {
        return new JSONObject().put("ContentType", (Object)attachment.getContentType()).put("ContentID", (Object)attachment.getId()).put("Filename", (Object)attachment.getFilename()).put("Base64Content", (Object)Base64.getEncoder().encodeToString(attachment.getContent()));
    }

    @NonNull
    private static Optional<JSONArray> to(@NonNull Email email) {
        if (CollectionUtils.isEmpty((Collection)email.getTo())) {
            return Optional.empty();
        }
        JSONArray arr = new JSONArray();
        for (Contact to : email.getTo()) {
            arr.put((Object)MailjetEmailComposer.createJsonObject(to));
        }
        return Optional.of(arr);
    }

    @NonNull
    private static JSONObject createJsonObject(@NonNull Contact contact) {
        return new JSONObject().put("Email", (Object)contact.getEmail());
    }
}

