/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email.mailjet;

import com.mailjet.client.ClientOptions;
import com.mailjet.client.MailjetClient;
import com.mailjet.client.MailjetRequest;
import com.mailjet.client.MailjetResponse;
import com.mailjet.client.errors.MailjetException;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.email.AsyncTransactionalEmailSender;
import io.micronaut.email.Email;
import io.micronaut.email.EmailException;
import io.micronaut.email.TransactionalEmailSender;
import io.micronaut.email.mailjet.MailjetConfiguration;
import io.micronaut.email.mailjet.MailjetEmailComposer;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Named(value="mailjet")
@Requires(beans={MailjetConfiguration.class, MailjetEmailComposer.class})
@Singleton
public class MailjetEmailSender
implements TransactionalEmailSender<MailjetRequest, MailjetResponse>,
AsyncTransactionalEmailSender<MailjetRequest, MailjetResponse> {
    public static final String NAME = "mailjet";
    private static final Logger LOG = LoggerFactory.getLogger(MailjetEmailSender.class);
    private final MailjetClient mailjetClient;
    private final MailjetEmailComposer mailjetEmailComposer;

    public MailjetEmailSender(MailjetConfiguration mailjetConfiguration, MailjetEmailComposer mailjetEmailComposer) {
        this.mailjetEmailComposer = mailjetEmailComposer;
        ClientOptions clientOptions = ClientOptions.builder().apiKey(mailjetConfiguration.getApiKey()).apiSecretKey(mailjetConfiguration.getApiSecret()).build();
        this.mailjetClient = new MailjetClient(clientOptions);
    }

    @NonNull
    public String getName() {
        return NAME;
    }

    @NonNull
    public MailjetResponse send(@NonNull @NotNull @Valid Email email, @NonNull @NotNull Consumer<MailjetRequest> emailRequest) throws EmailException {
        MailjetRequest request = (MailjetRequest)this.mailjetEmailComposer.compose(email, emailRequest);
        try {
            MailjetResponse response = this.mailjetClient.post(request);
            if (LOG.isTraceEnabled()) {
                LOG.trace("response status: {}", (Object)response.getStatus());
                LOG.trace("response data: {}", (Object)response.getData().toString());
            }
            return response;
        }
        catch (MailjetException e) {
            throw new EmailException((Throwable)e);
        }
    }

    @NonNull
    public Publisher<MailjetResponse> sendAsync(@NonNull @NotNull @Valid Email email, @NonNull @NotNull Consumer<MailjetRequest> emailRequest) throws EmailException {
        MailjetRequest request = (MailjetRequest)this.mailjetEmailComposer.compose(email, emailRequest);
        return Mono.fromFuture((CompletableFuture)this.mailjetClient.postAsync(request));
    }
}

