/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email.sendgrid;

import com.sendgrid.APICallback;
import com.sendgrid.Request;
import com.sendgrid.Response;
import com.sendgrid.SendGrid;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.email.AsyncTransactionalEmailSender;
import io.micronaut.email.Email;
import io.micronaut.email.EmailException;
import io.micronaut.email.TransactionalEmailSender;
import io.micronaut.email.sendgrid.SendGridConfiguration;
import io.micronaut.email.sendgrid.SendgridEmailComposer;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

@Requires(beans={SendGridConfiguration.class, SendgridEmailComposer.class})
@Named(value="sendgrid")
@Singleton
public class SendgridEmailSender
implements TransactionalEmailSender<Request, Response>,
AsyncTransactionalEmailSender<Request, Response> {
    public static final String NAME = "sendgrid";
    private static final Logger LOG = LoggerFactory.getLogger(SendgridEmailSender.class);
    private final SendGrid sendGrid;
    private final SendgridEmailComposer sendgridEmailComposer;

    public SendgridEmailSender(SendGridConfiguration sendGridConfiguration, SendgridEmailComposer sendgridEmailComposer) {
        this.sendGrid = new SendGrid(sendGridConfiguration.getApiKey());
        this.sendgridEmailComposer = sendgridEmailComposer;
    }

    @NonNull
    public String getName() {
        return NAME;
    }

    @NonNull
    public Response send(@NonNull @NotNull @Valid Email email, @NonNull @NotNull Consumer<Request> emailRequest) throws EmailException {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Sending email to {}", (Object)email.getTo());
            }
            return this.send((Request)this.sendgridEmailComposer.compose(email, emailRequest));
        }
        catch (IOException ex) {
            throw new EmailException((Throwable)ex);
        }
    }

    private Response send(@NonNull Request request) throws IOException {
        Response response = this.sendGrid.api(request);
        if (LOG.isInfoEnabled()) {
            LOG.info("Status Code: {}", (Object)String.valueOf(response.getStatusCode()));
            LOG.info("Body: {}", (Object)response.getBody());
            LOG.info("Headers {}", (Object)response.getHeaders().keySet().stream().map(key -> key.toString() + "=" + (String)response.getHeaders().get(key)).collect(Collectors.joining(", ", "{", "}")));
        }
        return response;
    }

    @NonNull
    public Publisher<Response> sendAsync(@NonNull @NotNull @Valid Email email, @NonNull @NotNull Consumer<Request> emailRequest) throws EmailException {
        return Mono.create(callback -> this.sendGrid.attempt((Request)this.sendgridEmailComposer.compose(email, emailRequest), new APICallback(){
            final /* synthetic */ MonoSink val$callback;
            {
                this.val$callback = monoSink;
            }

            public void error(Exception ex) {
                this.val$callback.error((Throwable)ex);
            }

            public void response(Response response) {
                this.val$callback.success((Object)response);
            }
        }));
    }
}

