/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email.template;

import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.Writable;
import io.micronaut.email.Body;
import io.micronaut.email.BodyType;
import io.micronaut.email.Email;
import io.micronaut.email.EmailDecorator;
import io.micronaut.email.MultipartBody;
import io.micronaut.email.template.DefaultTemplateBodyDecorator;
import io.micronaut.email.template.TemplateBody;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.views.ModelAndView;
import io.micronaut.views.ViewsRenderer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;

@DefaultImplementation(value=DefaultTemplateBodyDecorator.class)
public interface TemplateBodyDecorator
extends EmailDecorator {
    public Logger getLogger();

    @NonNull
    public Optional<ViewsRenderer> resolveViewsRenderer(@NonNull BodyType var1, @NonNull String var2, @Nullable Object var3);

    default public void decorate(@NonNull @NotNull Email.Builder emailBuilder) {
        Optional optionalBody = emailBuilder.getBody();
        if (optionalBody.isPresent()) {
            Body body = (Body)optionalBody.get();
            if (body instanceof TemplateBody) {
                if (body.get(BodyType.HTML).isPresent()) {
                    this.renderBody((TemplateBody)body, BodyType.HTML);
                } else if (body.get(BodyType.TEXT).isPresent()) {
                    this.renderBody((TemplateBody)body, BodyType.TEXT);
                }
            } else if (body instanceof MultipartBody) {
                MultipartBody multipartBody = (MultipartBody)body;
                if (multipartBody.getHtml() instanceof TemplateBody) {
                    this.renderBody((TemplateBody)multipartBody.getHtml(), BodyType.HTML);
                }
                if (multipartBody.getText() instanceof TemplateBody) {
                    this.renderBody((TemplateBody)multipartBody.getText(), BodyType.TEXT);
                }
            }
        }
    }

    default public void renderBody(@NonNull TemplateBody<?> body, @NonNull BodyType bodyType) {
        block4: {
            ModelAndView<?> modelAndView = body.getModelAndView();
            String viewName = modelAndView.getView().orElse(null);
            if (viewName == null) {
                return;
            }
            Optional<ViewsRenderer> optionalViewsRenderer = this.resolveViewsRenderer(bodyType, viewName, modelAndView.getModel().orElse(null));
            if (!optionalViewsRenderer.isPresent()) {
                return;
            }
            Writable writable = optionalViewsRenderer.get().render(viewName, modelAndView.getModel().orElse(null), (HttpRequest)ServerRequestContext.currentRequest().orElse(null));
            StringWriter stringWriter = new StringWriter();
            try {
                writable.writeTo((Writer)stringWriter);
                body.setBody(stringWriter.toString());
            }
            catch (IOException e) {
                if (!this.getLogger().isErrorEnabled()) break block4;
                this.getLogger().error("IO exception writing template to String", (Throwable)e);
            }
        }
    }
}

