/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email.template;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.email.BodyType;
import io.micronaut.email.template.TemplateBodyDecorator;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.ViewsRendererLocator;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(beans={ViewsRendererLocator.class})
@Singleton
public class DefaultTemplateBodyDecorator
implements TemplateBodyDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTemplateBodyDecorator.class);
    private static final String TEXT_HTML = "text/html";
    private static final String TEXT_PLAIN = "text/plain";
    private final ViewsRendererLocator viewsRendererLocator;

    public DefaultTemplateBodyDecorator(ViewsRendererLocator viewsRendererLocator) {
        this.viewsRendererLocator = viewsRendererLocator;
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    @NonNull
    public Optional<ViewsRenderer> resolveViewsRenderer(@NonNull BodyType bodyType, @NonNull String viewName, @Nullable Object data) {
        return this.viewsRendererLocator.resolveViewsRenderer(viewName, this.mediaTypeForBodyType(bodyType), data);
    }

    @NonNull
    private String mediaTypeForBodyType(@NonNull BodyType bodyType) {
        switch (bodyType) {
            case TEXT: {
                return TEXT_PLAIN;
            }
        }
        return TEXT_HTML;
    }
}

