/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email.template;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.email.Body;
import io.micronaut.email.BodyType;
import io.micronaut.views.ModelAndView;
import java.util.Optional;

public class TemplateBody<T>
implements Body {
    @NonNull
    private final ModelAndView<T> modelAndView;
    @NonNull
    private String body = "";
    @NonNull
    private final BodyType bodyType;

    public TemplateBody(@Nullable String view, @Nullable T model) {
        this(new ModelAndView(view, model));
    }

    public TemplateBody(@NonNull ModelAndView<T> modelAndView) {
        this(BodyType.HTML, modelAndView);
    }

    public TemplateBody(@NonNull BodyType bodyType, @Nullable String view, @Nullable T model) {
        this(bodyType, new ModelAndView(view, model));
    }

    public TemplateBody(@NonNull BodyType bodyType, @NonNull ModelAndView<T> modelAndView) {
        this.modelAndView = modelAndView;
        this.bodyType = bodyType;
    }

    @NonNull
    public ModelAndView<T> getModelAndView() {
        return this.modelAndView;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @NonNull
    public Optional<String> get(@NonNull BodyType bodyType) {
        return this.bodyType == bodyType ? Optional.of(this.body) : Optional.empty();
    }
}

